/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.mejb;

import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.management.mejb.ClientNotificationListener;
import org.jboss.management.mejb.MEJB;

public class PollingClientNotificationListener
extends ClientNotificationListener
implements Runnable {
    private MEJB mConnector;
    private int mSleepingPeriod = 2000;

    public PollingClientNotificationListener(ObjectName pSender, NotificationListener pClientListener, Object pHandback, NotificationFilter pFilter, int pSleepingPeriod, int pMaximumListSize, MEJB pConnector) throws JMException, RemoteException {
        super(pSender, pClientListener, pHandback);
        if (pSleepingPeriod > 0) {
            this.mSleepingPeriod = pSleepingPeriod;
        }
        this.mConnector = pConnector;
        this.createListener(pConnector, "org.jboss.management.mejb.PollingNotificationListener", new Object[]{new Integer(pMaximumListSize), new Integer(pMaximumListSize)}, new String[]{Integer.TYPE.getName(), Integer.TYPE.getName()});
        this.addNotificationListener(pConnector, pFilter);
        new Thread(this).start();
    }

    public void run() {
        while (true) {
            try {
                try {
                    List lNotifications = (List)this.mConnector.invoke(this.getRemoteListenerName(), "getNotifications", new Object[0], new String[0]);
                    Iterator i = lNotifications.iterator();
                    while (i.hasNext()) {
                        Notification lNotification = (Notification)i.next();
                        this.mClientListener.handleNotification(lNotification, this.mHandback);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"PollingClientNotificationListener.getNotifications() failed", (Throwable)e);
                }
                Thread.sleep(this.mSleepingPeriod);
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }
}

