/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractConstructorMetaData
extends AbstractFeatureMetaData
implements ConstructorMetaData {
    protected List<ParameterMetaData> parameters;
    protected ValueMetaData value;
    protected ValueMetaData factory;
    protected String factoryClassName;
    protected String factoryMethod;

    public void setParameters(List<ParameterMetaData> parameters) {
        this.parameters = parameters;
        this.flushJBossObjectCache();
    }

    public void setValue(ValueMetaData value) {
        this.value = value;
        this.flushJBossObjectCache();
    }

    public void setFactory(ValueMetaData factory) {
        this.factory = factory;
        this.flushJBossObjectCache();
    }

    public void setFactoryClass(String name) {
        this.factoryClassName = name;
        this.flushJBossObjectCache();
    }

    public void setFactoryMethod(String name) {
        this.factoryMethod = name;
        this.flushJBossObjectCache();
    }

    @Override
    public List<ParameterMetaData> getParameters() {
        return this.parameters;
    }

    @Override
    public ValueMetaData getValue() {
        return this.value;
    }

    @Override
    public ValueMetaData getFactory() {
        return this.factory;
    }

    @Override
    public String getFactoryClass() {
        return this.factoryClassName;
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    protected void addChildren(Set<MetaDataVisitorNode> children) {
        super.addChildren(children);
        if (this.parameters != null) {
            children.addAll(this.parameters);
        }
        if (this.value != null) {
            children.add(this.value);
        }
        if (this.factory != null) {
            children.add(this.factory);
        }
    }

    @Override
    public Class getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        if (this.factory != null || this.factoryClassName != null) {
            ClassInfo classInfo;
            KernelControllerContext context = visitor.getControllerContext();
            ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
            KernelConfigurator configurator = context.getKernel().getConfigurator();
            if (this.factory != null) {
                Object target = this.factory.getValue(null, cl);
                classInfo = configurator.getClassInfo(target.getClass());
            } else {
                classInfo = configurator.getClassInfo(this.factoryClassName, cl);
            }
            ParameterMetaData parameter = (ParameterMetaData)previous;
            String[] parameterTypes = Configurator.getParameterTypes(false, this.parameters);
            MethodInfo methodInfo = Configurator.findMethodInfo((ClassInfo)classInfo, (String)this.factoryMethod, (String[])parameterTypes, (this.factoryClassName != null ? 1 : 0) != 0, (boolean)true);
            return this.applyCollectionOrMapCheck(methodInfo.getParameterTypes()[parameter.getIndex()].getType());
        }
        KernelControllerContext context = visitor.getControllerContext();
        BeanInfo beanInfo = context.getBeanInfo();
        if (previous instanceof ParameterMetaData) {
            ParameterMetaData parameter = (ParameterMetaData)previous;
            String[] paramTypes = Configurator.getParameterTypes(false, this.parameters);
            ConstructorInfo ci = Configurator.findConstructorInfo((ClassInfo)beanInfo.getClassInfo(), (String[])paramTypes);
            return this.applyCollectionOrMapCheck(ci.getParameterTypes()[parameter.getIndex()].getType());
        }
        Class type = beanInfo.getClassInfo().getType();
        this.log.warn((Object)("Constructing bean from injection value: results in multiple beans with same class type - " + type));
        return type;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("parameters=");
        JBossObject.list((JBossStringBuilder)buffer, this.parameters);
        if (this.value != null) {
            buffer.append(" value=").append((Object)this.value);
        }
        if (this.factory != null) {
            buffer.append(" factory=").append((Object)this.factory);
        }
        if (this.factoryClassName != null) {
            buffer.append(" factoryClass=").append(this.factoryClassName);
        }
        if (this.factoryMethod != null) {
            buffer.append(" factoryMethod=").append(this.factoryMethod);
        }
        super.toString(buffer);
    }
}

