/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.Stack;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.util.JBossStringBuilder;

public abstract class AbstractTypeMetaData
extends AbstractValueMetaData {
    protected String type;
    protected KernelController controller;
    protected KernelConfigurator configurator;
    protected String propertyName;
    protected String beanName;

    public AbstractTypeMetaData() {
    }

    public AbstractTypeMetaData(String value) {
        super(value);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void initialVisit(MetaDataVisitor visitor) {
        this.controller = (KernelController)visitor.getControllerContext().getController();
        this.configurator = visitor.getControllerContext().getKernel().getConfigurator();
        this.preparePreinstantiatedLookup(visitor);
        visitor.initialVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preparePreinstantiatedLookup(MetaDataVisitor visitor) {
        Stack<MetaDataVisitorNode> visitorNodes = visitor.visitorNodeStack();
        MetaDataVisitorNode parent = visitorNodes.pop();
        try {
            if (parent instanceof PropertyMetaData) {
                PropertyMetaData pmd = (PropertyMetaData)parent;
                this.propertyName = pmd.getName();
                MetaDataVisitorNode gp = visitorNodes.peek();
                if (gp instanceof BeanMetaData) {
                    BeanMetaData bmd = (BeanMetaData)gp;
                    this.beanName = bmd.getName();
                }
            }
        }
        finally {
            visitorNodes.push(parent);
        }
    }

    protected Object preinstantiatedLookup(ClassLoader cl, Class expected) {
        Object result = null;
        if (this.propertyName != null && this.beanName != null) {
            try {
                KernelControllerContext context = (KernelControllerContext)this.controller.getContext(this.beanName, ControllerState.INSTANTIATED);
                TargettedJoinpoint joinpoint = this.configurator.getPropertyGetterJoinPoint(context.getBeanInfo(), this.propertyName);
                joinpoint.setTarget(context.getTarget());
                result = joinpoint.dispatch();
            }
            catch (Throwable t) {
                this.log.warn((Object)("Exception in preinstantiated lookup: " + t));
            }
            if (result != null && expected != null && !expected.isAssignableFrom(result.getClass())) {
                throw new ClassCastException(result.getClass() + " is not a " + expected.getName());
            }
        }
        return result;
    }

    public void setConfigurator(KernelConfigurator configurator) {
        this.configurator = configurator;
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.type != null) {
            buffer.append(" type=").append(this.type);
        }
    }

    protected ClassInfo getClassInfo(ClassLoader cl) throws Throwable {
        return this.getClassInfo(this.type, cl);
    }

    protected ClassInfo getClassInfo(String classType, ClassLoader cl) throws Throwable {
        if (classType == null) {
            return null;
        }
        return this.configurator.getClassInfo(classType, cl);
    }

    protected Class getClass(MetaDataVisitor visitor, String classType) throws Throwable {
        KernelControllerContext context = visitor.getControllerContext();
        ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
        return this.getClassInfo(classType, cl).getType();
    }
}

