/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.ClassContextDependencyItem;
import org.jboss.kernel.plugins.dependency.KernelControllerContextActions;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.MutableMetaDataContext;
import org.jboss.repository.spi.MetaDataContext;
import org.jboss.util.JBossStringBuilder;

public class AbstractKernelControllerContext
extends AbstractControllerContext
implements KernelControllerContext {
    private static final KernelControllerContextActions actions = KernelControllerContextActions.getInstance();
    private static final KernelControllerContextActions noInstantiate = KernelControllerContextActions.getNoInstantiate();
    protected BeanInfo info;
    protected BeanMetaData metaData;
    protected AccessControlContext accessContext;
    protected boolean isDescribeProcessed;

    public AbstractKernelControllerContext(BeanInfo info, BeanMetaData metaData, Object target) {
        super((Object)metaData.getName(), (ControllerContextActions)(target == null ? actions : noInstantiate), (DependencyInfo)new AbstractDependencyInfo(), target);
        this.info = info;
        this.metaData = metaData;
        ControllerMode mode = metaData.getMode();
        if (mode != null) {
            this.setMode(mode);
        }
        if (System.getSecurityManager() != null) {
            this.accessContext = AccessController.getContext();
        }
    }

    public Kernel getKernel() {
        KernelController controller = (KernelController)this.getController();
        if (controller == null) {
            throw new IllegalStateException("Context is not installed in controller");
        }
        return controller.getKernel();
    }

    public BeanInfo getBeanInfo() {
        return this.info;
    }

    public void setBeanInfo(BeanInfo info) {
        this.info = info;
        this.infoprocessMetaData();
        this.flushJBossObjectCache();
    }

    public BeanMetaData getBeanMetaData() {
        return this.metaData;
    }

    public void toString(JBossStringBuilder buffer) {
        if (this.metaData != null) {
            buffer.append(" metadata=").append((Object)this.metaData);
        }
        super.toString(buffer);
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.preprocessMetaData();
    }

    protected void preprocessMetaData() {
        if (this.metaData == null) {
            return;
        }
        PreprocessMetaDataVisitor visitor = new PreprocessMetaDataVisitor(this.metaData);
        AccessController.doPrivileged(visitor);
    }

    protected void infoprocessMetaData() {
        if (this.info == null) {
            this.removeClassContextReference();
            return;
        }
        if (this.isDescribeProcessed) {
            return;
        }
        DescribedMetaDataVisitor visitor = new DescribedMetaDataVisitor(this.metaData);
        AccessController.doPrivileged(visitor);
        this.isDescribeProcessed = true;
    }

    public MutableMetaDataContext getMetaDataContext() {
        if (this.info != null) {
            try {
                return (MutableMetaDataContext)this.info.getMetaDataContext();
            }
            catch (ClassCastException e) {
                throw new RuntimeException("MetaDataContext must be an instance of MutableMetaDataContext");
            }
        }
        return null;
    }

    public void setMetaDataContext(MetaDataContext mctx) {
        this.info = this.info.getInstanceInfo();
        this.info.setMetaDataContext(mctx);
    }

    protected AccessControlContext getAccessControlContext() {
        return this.accessContext;
    }

    private void removeClassContextReference() {
        DependencyInfo dependencyInfo = this.getDependencyInfo();
        if (dependencyInfo != null) {
            Set dependencys = dependencyInfo.getIDependOn(ClassContextDependencyItem.class);
            for (DependencyItem di : dependencys) {
                di.unresolved(this.getController());
            }
        }
    }

    protected class DescribedMetaDataVisitor
    extends AbstractMetaDataVistor {
        public DescribedMetaDataVisitor(BeanMetaData bmd) {
            super(bmd);
        }

        public Object run() {
            this.bmd.describeVisit(this);
            this.visitorNodeStack = null;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void internalDescribeVisit(MetaDataVisitorNode node) {
            Iterator<? extends MetaDataVisitorNode> children;
            boolean trace = AbstractKernelControllerContext.this.log.isTraceEnabled();
            if (trace) {
                AbstractKernelControllerContext.this.log.trace((Object)("Describe visit node " + node));
            }
            if ((children = node.getChildren()) != null) {
                ControllerState restoreState = this.contextState;
                while (children.hasNext()) {
                    MetaDataVisitorNode child = children.next();
                    try {
                        child.describeVisit(this);
                    }
                    finally {
                        this.contextState = restoreState;
                    }
                }
            }
        }
    }

    protected class PreprocessMetaDataVisitor
    extends AbstractMetaDataVistor {
        public PreprocessMetaDataVisitor(BeanMetaData bmd) {
            super(bmd);
        }

        public Object run() {
            this.bmd.initialVisit(this);
            this.visitorNodeStack = null;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void internalInitialVisit(MetaDataVisitorNode node) {
            Iterator<? extends MetaDataVisitorNode> children;
            boolean trace = AbstractKernelControllerContext.this.log.isTraceEnabled();
            if (trace) {
                AbstractKernelControllerContext.this.log.trace((Object)("Initial visit node " + node));
            }
            if ((children = node.getChildren()) != null) {
                ControllerState restoreState = this.contextState;
                while (children.hasNext()) {
                    MetaDataVisitorNode child = children.next();
                    try {
                        child.initialVisit(this);
                    }
                    finally {
                        this.contextState = restoreState;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractMetaDataVistor
    implements MetaDataVisitor,
    PrivilegedAction<Object> {
        protected ControllerState contextState = ControllerState.INSTANTIATED;
        protected BeanMetaData bmd;
        protected Stack<MetaDataVisitorNode> visitorNodeStack;

        protected AbstractMetaDataVistor(BeanMetaData bmd) {
            this.bmd = bmd;
            this.visitorNodeStack = new Stack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialVisit(MetaDataVisitorNode node) {
            this.visitorNodeStack.push(node);
            try {
                this.internalInitialVisit(node);
            }
            finally {
                this.visitorNodeStack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void describeVisit(MetaDataVisitorNode node) {
            this.visitorNodeStack.push(node);
            try {
                this.internalDescribeVisit(node);
            }
            finally {
                this.visitorNodeStack.pop();
            }
        }

        protected void internalInitialVisit(MetaDataVisitorNode node) {
        }

        protected void internalDescribeVisit(MetaDataVisitorNode node) {
        }

        @Override
        public KernelControllerContext getControllerContext() {
            return AbstractKernelControllerContext.this;
        }

        @Override
        public ControllerState getContextState() {
            return this.contextState;
        }

        @Override
        public void addDependency(DependencyItem dependency) {
            AbstractKernelControllerContext.this.getDependencyInfo().addIDependOn(dependency);
        }

        @Override
        public void setContextState(ControllerState contextState) {
            this.contextState = contextState;
        }

        @Override
        public Stack<MetaDataVisitorNode> visitorNodeStack() {
            return this.visitorNodeStack;
        }
    }
}

