/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.MutableMetaDataContext;
import org.jboss.metadata.spi.repository.MetaDataRepository;
import org.jboss.repository.spi.MetaDataContext;
import org.jboss.repository.spi.MetaDataContextFactory;

public class DescribeAction
extends KernelControllerContextAction {
    public void installAction(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        if (metaData.getBean() != null) {
            BeanInfo info = configurator.getBeanInfo(metaData);
            context.setBeanInfo(info);
            info = this.addAnnotations(context, metaData, info);
            DependencyInfo depends = context.getDependencyInfo();
            List dependencies = info.getDependencies();
            if (dependencies != null) {
                for (Object dependencyName : dependencies) {
                    AbstractDependencyItem dependency = new AbstractDependencyItem((Object)metaData.getName(), dependencyName, ControllerState.INSTANTIATED, ControllerState.INSTALLED);
                    depends.addIDependOn((DependencyItem)dependency);
                }
            }
        }
    }

    public void uninstallAction(KernelControllerContext context) {
        context.setMetaDataContext(null);
        context.setBeanInfo(null);
    }

    private BeanInfo addAnnotations(KernelControllerContext context, BeanMetaData beanMetaData, BeanInfo beanInfo) {
        MutableMetaDataContext metaCtx = this.addClassAnnotations(context, beanMetaData, beanInfo);
        this.addPropertyAnnotations(metaCtx, context, beanMetaData, beanInfo);
        return context.getBeanInfo();
    }

    private MutableMetaDataContext addClassAnnotations(KernelControllerContext context, BeanMetaData beanMetaData, BeanInfo beanInfo) {
        Set<AnnotationMetaData> annotations = beanMetaData.getAnnotations();
        MutableMetaDataContext metaCtx = null;
        if (annotations != null && annotations.size() > 0 && (metaCtx = this.getMetaDataContext(context)) != null) {
            metaCtx.addAnnotations(annotations);
        }
        return metaCtx;
    }

    private MutableMetaDataContext addPropertyAnnotations(MutableMetaDataContext metaCtx, KernelControllerContext context, BeanMetaData beanMetaData, BeanInfo beanInfo) {
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties != null && properties.size() > 0) {
            for (PropertyMetaData property : properties) {
                Set propertyInfos;
                Set<AnnotationMetaData> propertyAnnotations = property.getAnnotations();
                if (propertyAnnotations == null || propertyAnnotations.size() <= 0) continue;
                if (metaCtx == null) {
                    metaCtx = this.getMetaDataContext(context);
                }
                if (metaCtx == null || (propertyInfos = beanInfo.getProperties()) == null || propertyInfos.size() <= 0) continue;
                metaCtx.addPropertyAnnotations(property.getName(), beanInfo.getProperties(), propertyAnnotations);
            }
        }
        return metaCtx;
    }

    private MutableMetaDataContext getMetaDataContext(KernelControllerContext context) {
        ClassLoader beanLoader;
        ControllerContext repCtx = context.getController().getContext((Object)"Repository", ControllerState.INSTALLED);
        if (repCtx == null) {
            this.log.warn((Object)("You have defined annotations for bean '" + context.getName() + "', but no MetaDataRepository has been installed under the name 'Repository'"));
            return null;
        }
        MetaDataRepository repository = (MetaDataRepository)repCtx.getTarget();
        MetaDataContextFactory metaFactory = context.getBeanInfo().getMetaDataContextFactory();
        MetaDataContext metaCtx = metaFactory.getMetaDataContext(beanLoader = context.getBeanInfo().getClassInfo().getType().getClassLoader(), repository, (String)context.getName());
        if (!(metaCtx instanceof MutableMetaDataContext)) {
            throw new RuntimeException("MetaDataContext must be mutable");
        }
        context.setMetaDataContext(metaCtx);
        return (MutableMetaDataContext)metaCtx;
    }
}

