/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.registry.KernelRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallAction
extends KernelControllerContextAction {
    @Override
    public void installAction(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelRegistry registry = kernel.getRegistry();
        BeanMetaData metaData = context.getBeanMetaData();
        String name = metaData.getName();
        registry.registerEntry(name, context);
        controller.addSupplies(context);
        List<InstallMetaData> installs = metaData.getInstalls();
        if (installs != null) {
            for (int i = 0; i < installs.size(); ++i) {
                InstallMetaData install = installs.get(i);
                KernelControllerContext target = context;
                if (install.getBean() != null) {
                    target = (KernelControllerContext)controller.getContext(install.getBean(), install.getDependentState());
                }
                this.dispatch(target, install.getMethodName(), install.getParameters());
            }
        }
    }

    @Override
    public void uninstallAction(KernelControllerContext context) {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelRegistry registry = kernel.getRegistry();
        BeanMetaData metaData = context.getBeanMetaData();
        String name = metaData.getName();
        List<InstallMetaData> uninstalls = metaData.getUninstalls();
        if (uninstalls != null) {
            for (int i = uninstalls.size() - 1; i >= 0; --i) {
                InstallMetaData uninstall = uninstalls.get(i);
                KernelControllerContext target = context;
                if (uninstall.getBean() != null && (target = (KernelControllerContext)controller.getContext(uninstall.getBean(), uninstall.getDependentState())) == null) {
                    this.log.warn((Object)("Ignoring uninstall action on target in incorrect state " + uninstall.getBean()));
                    continue;
                }
                try {
                    this.dispatch(target, uninstall.getMethodName(), uninstall.getParameters());
                    continue;
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Ignoring uninstall action on target " + uninstall), t);
                }
            }
        }
        try {
            controller.removeSupplies(context);
            registry.unregisterEntry(name);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Ignoring unregistered entry at uninstall " + name));
        }
    }

    protected void dispatch(KernelControllerContext context, String method, List<ParameterMetaData> parameters) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        KernelConfigurator configurator = controller.getKernel().getConfigurator();
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        ClassLoader cl = Configurator.getClassLoader(metaData);
        MethodJoinpoint joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
        joinpoint.setTarget(context.getTarget());
        InstallAction.dispatchJoinPoint(context, (Joinpoint)joinpoint);
    }
}

