/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractKernelDeployment
extends JBossObject
implements KernelDeployment {
    protected String name;
    protected boolean installed;
    protected List<KernelControllerContext> installedContexts = CollectionsFactory.createCopyOnWriteList();
    protected List<BeanMetaDataFactory> beanFactories;
    protected ClassLoaderMetaData classLoader;

    public void setBeans(List beans) {
        this.beanFactories = beans;
        this.flushJBossObjectCache();
    }

    public void setBeanFactories(List<BeanMetaDataFactory> beanFactories) {
        this.beanFactories = beanFactories;
        this.flushJBossObjectCache();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    @Override
    public void setInstalled(boolean installed) {
        this.installed = installed;
        this.flushJBossObjectCache();
    }

    @Override
    public void addInstalledContext(KernelControllerContext context) {
        this.installedContexts.add(context);
        this.flushJBossObjectCache();
    }

    @Override
    public List<KernelControllerContext> getInstalledContexts() {
        return this.installedContexts;
    }

    @Override
    public void removeInstalledContext(KernelControllerContext context) {
        this.installedContexts.remove(context);
        this.flushJBossObjectCache();
    }

    @Override
    public List<BeanMetaData> getBeans() {
        if (this.beanFactories == null || this.beanFactories.size() == 0) {
            return null;
        }
        ArrayList<BeanMetaData> result = new ArrayList<BeanMetaData>(this.beanFactories.size());
        for (int i = 0; i < this.beanFactories.size(); ++i) {
            BeanMetaDataFactory factory = this.beanFactories.get(i);
            List<BeanMetaData> beans = factory.getBeans();
            result.addAll(beans);
        }
        return result;
    }

    @Override
    public List<BeanMetaDataFactory> getBeanFactories() {
        return this.beanFactories;
    }

    @Override
    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" installed=").append(this.installed);
        if (this.classLoader != null) {
            buffer.append(" classLoader=").append((Object)this.classLoader);
        }
        if (this.beanFactories != null) {
            buffer.append(" beanFactories=").append(this.beanFactories);
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }
}

