/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.util.List;
import java.util.ListIterator;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.collection.CollectionsFactory;

public class BasicKernelDeployer
extends AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger(BasicKernelDeployer.class);
    protected List<KernelDeployment> deployments = CollectionsFactory.createCopyOnWriteList();

    public BasicKernelDeployer(Kernel kernel) {
        super(kernel);
    }

    public void deploy(KernelDeployment deployment) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Deploying " + deployment));
        }
        super.deploy(deployment);
        this.deployments.add(deployment);
        if (trace) {
            log.trace((Object)("Deployed " + deployment));
        }
    }

    public void undeploy(KernelDeployment deployment) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Undeploying " + deployment));
        }
        this.deployments.remove(deployment);
        super.undeploy(deployment);
        if (trace) {
            log.trace((Object)("Undeployed " + deployment));
        }
    }

    public void shutdown() {
        ListIterator<KernelDeployment> iterator = this.deployments.listIterator(this.deployments.size());
        while (iterator.hasPrevious()) {
            KernelDeployment deployment = iterator.previous();
            this.undeploy(deployment);
        }
    }
}

