/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.junit;

import java.net.URL;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.AbstractTestDelegate;

public class MicrocontainerTestDelegate
extends AbstractTestDelegate {
    protected Kernel kernel;
    protected BasicXMLDeployer deployer;

    public MicrocontainerTestDelegate(Class clazz) throws Exception {
        super(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            AbstractBootstrap bootstrap = this.getBootstrap();
            bootstrap.run();
            this.kernel = bootstrap.getKernel();
            this.deployer = new BasicXMLDeployer(this.kernel);
            this.deploy();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.undeploy();
    }

    protected AbstractBootstrap getBootstrap() throws Exception {
        return new BasicBootstrap();
    }

    protected Object getBean(Object name, ControllerState state) {
        KernelControllerContext context = this.getControllerContext(name, state);
        return context.getTarget();
    }

    protected KernelControllerContext getControllerContext(Object name, ControllerState state) {
        KernelController controller = this.kernel.getController();
        KernelControllerContext context = (KernelControllerContext)controller.getContext(name, state);
        if (context == null) {
            throw new IllegalStateException("Bean not found " + name + " at state " + state);
        }
        return context;
    }

    protected void validate() throws Exception {
        try {
            this.deployer.validate();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected KernelDeployment deploy(URL url) throws Exception {
        try {
            this.log.debug((Object)("Deploying " + url));
            KernelDeployment deployment = this.deployer.deploy(url);
            this.log.trace((Object)("Deployed " + url));
            return deployment;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected void undeploy(KernelDeployment deployment) {
        this.log.debug((Object)("Undeploying " + deployment.getName()));
        try {
            this.deployer.undeploy(deployment);
            this.log.trace((Object)("Undeployed " + deployment.getName()));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during undeployment: " + deployment.getName()), t);
        }
    }

    protected void undeploy(URL url) {
        this.log.debug((Object)("Undeploying " + url));
        try {
            this.deployer.undeploy(url);
            this.log.trace((Object)("Undeployed " + url));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during undeployment: " + url), t);
        }
    }

    protected void deploy() throws Exception {
        String testName = this.clazz.getName();
        testName = testName.replace('.', '/') + ".xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url != null) {
            this.deploy(url);
        } else {
            this.log.debug((Object)("No test specific deployment " + testName));
        }
    }

    protected void undeploy() {
        this.log.debug((Object)("Undeploying " + this.deployer.getDeploymentNames()));
        this.deployer.shutdown();
    }
}

