/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomainMBean;
import org.jboss.management.j2ee.J2EEManagedObject;

public class J2EEDomain
extends J2EEManagedObject
implements J2EEDomainMBean {
    public static final String J2EE_TYPE = "J2EEDomain";
    private static String domainName = null;
    private List mServers = new ArrayList();

    public static String getDomainName() {
        return domainName;
    }

    public static ObjectName getDomainServerName(MBeanServer mbeanServer) {
        ObjectName domainServer = null;
        try {
            ObjectName serverQuery = new ObjectName(domainName + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*");
            Set<ObjectName> servers = mbeanServer.queryNames(serverQuery, null);
            if (!servers.isEmpty()) {
                domainServer = servers.iterator().next();
            }
        }
        catch (Exception ignore) {}
        return domainServer;
    }

    public J2EEDomain(String domainName) throws MalformedObjectNameException, InvalidParentException {
        super(domainName, J2EE_TYPE, "Manager");
        J2EEDomain.domainName = domainName;
    }

    public ObjectName[] getServers() {
        return this.mServers.toArray(new ObjectName[0]);
    }

    public ObjectName getServer(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mServers.size()) {
            return (ObjectName)this.mServers.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("J2EEServer".equals(lType)) {
            this.mServers.add(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("J2EEServer".equals(lType)) {
            this.mServers.remove(pChild);
        }
    }

    public String toString() {
        return "J2EEDomain { " + super.toString() + " } [ " + ", servers: " + this.mServers + " ]";
    }
}

