/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.ServletMBean;
import org.jboss.management.j2ee.statistics.ServletStatsImpl;
import org.jboss.management.j2ee.statistics.TimeStatisticImpl;

public class Servlet
extends J2EEManagedObject
implements ServletMBean {
    public static final String J2EE_TYPE = "Servlet";
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$Servlet == null ? (class$org$jboss$management$j2ee$Servlet = Servlet.class$("org.jboss.management.j2ee.Servlet")) : class$org$jboss$management$j2ee$Servlet));
    private ObjectName servletServiceName;
    private ServletStatsImpl stats;
    static /* synthetic */ Class class$org$jboss$management$j2ee$Servlet;

    public static ObjectName create(MBeanServer mbeanServer, ObjectName webModuleName, ObjectName webContainerName, ObjectName servletServiceName) {
        try {
            Servlet servlet = new Servlet(servletServiceName, webModuleName, webContainerName);
            ObjectName jsr77Name = servlet.getObjectName();
            mbeanServer.registerMBean(servlet, jsr77Name);
            log.debug((Object)("Created JSR-77 Servlet: " + jsr77Name));
            return jsr77Name;
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 Servlet: " + servletServiceName), (Throwable)e);
            return null;
        }
    }

    public static void destroy(MBeanServer mbeanServer, ObjectName jsr77Name) {
        try {
            mbeanServer.unregisterMBean(jsr77Name);
            log.debug((Object)("Destroyed JSR-77 Servlet: " + jsr77Name));
        }
        catch (InstanceNotFoundException ignore) {
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 Servlet: " + jsr77Name), (Throwable)e);
        }
    }

    public Servlet(ObjectName servletServiceName, ObjectName webModuleName, ObjectName webContainerName) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, servletServiceName.getKeyProperty("name"), webModuleName);
        this.servletServiceName = servletServiceName;
        this.stats = new ServletStatsImpl();
    }

    public Stats getStats() {
        try {
            TimeStatisticImpl serviceTime = (TimeStatisticImpl)this.stats.getServiceTime();
            Integer count = (Integer)this.server.getAttribute(this.servletServiceName, "RequestCount");
            Long totalTime = (Long)this.server.getAttribute(this.servletServiceName, "ProcessingTime");
            Long minTime = (Long)this.server.getAttribute(this.servletServiceName, "MinTime");
            Long maxTime = (Long)this.server.getAttribute(this.servletServiceName, "MaxTime");
            serviceTime.set(count.longValue(), minTime, maxTime, totalTime);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retrieve stats", (Throwable)e);
        }
        return this.stats;
    }

    public void resetStats() {
        this.stats.reset();
    }

    public String toString() {
        return "Servlet { " + super.toString() + " } []";
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("WebModule", lProperties.get("name"));
        lReturn.put("J2EEApplication", lProperties.get("J2EEApplication"));
        lReturn.put("J2EEServer", lProperties.get("J2EEServer"));
        return lReturn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

