/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.StateManagement;
import org.jboss.management.j2ee.URLResourceMBean;

public class URLResource
extends J2EEResource
implements URLResourceMBean {
    public static final String J2EE_TYPE = "URLResource";
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$URLResource == null ? (class$org$jboss$management$j2ee$URLResource = URLResource.class$("org.jboss.management.j2ee.URLResource")) : class$org$jboss$management$j2ee$URLResource));
    private StateManagement mState;
    private ObjectName mService;
    static /* synthetic */ Class class$org$jboss$management$j2ee$URLResource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static ObjectName create(MBeanServer pServer, String pName, ObjectName pService) {
        ObjectName lServer = null;
        try {
            lServer = pServer.queryNames(new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
        }
        catch (Exception e) {
            log.error((Object)("Could not create JSR-77 URLResource: " + pName), (Throwable)e);
            return null;
        }
        try {
            return pServer.createMBean("org.jboss.management.j2ee.URLResource", null, new Object[]{pName, lServer, pService}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = URLResource.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = URLResource.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = URLResource.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()}).getObjectName();
        }
        catch (Exception e) {
            log.error((Object)("Could not create JSR-77 URLResource: " + pName), (Throwable)e);
            return null;
        }
    }

    public static void destroy(MBeanServer pServer, String pName) {
        try {
            J2EEManagedObject.removeObject(pServer, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + J2EE_TYPE + "," + "name=" + pName + "," + "*");
        }
        catch (Exception e) {
            log.error((Object)("Could not destroy JSR-77 URLResource: " + pName), (Throwable)e);
        }
    }

    public URLResource(String pName, ObjectName pServer, ObjectName pService) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, pName, pServer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service name: " + pService));
        }
        this.mService = pService;
        this.mState = new StateManagement(this);
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public void mejbStart() {
        try {
            this.server.invoke(this.mService, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            log.error((Object)"Start of URL Resource failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        this.mejbStart();
    }

    public void mejbStop() {
        try {
            this.server.invoke(this.mService, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            log.error((Object)"Stop of URL Resource failed", (Throwable)e);
        }
    }

    public void postCreation() {
        try {
            this.server.addNotificationListener(this.mService, this.mState, null, null);
        }
        catch (JMException e) {
            log.debug((Object)"Failed to add notification listener", (Throwable)e);
        }
        this.sendNotification("j2ee.object.created", "URL Resource created");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "URL Resource deleted");
        try {
            this.server.removeNotificationListener(this.mService, this.mState);
        }
        catch (JMException jme) {}
    }

    public String toString() {
        return "URLResource { " + super.toString() + " } [ " + " ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

