/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEApplication;
import org.jboss.management.j2ee.J2EEDeployedObject;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEModule;
import org.jboss.management.j2ee.WebModuleMBean;

public class WebModule
extends J2EEModule
implements WebModuleMBean {
    public static final String J2EE_TYPE = "WebModule";
    private static final String[] eventTypes = new String[]{"j2ee.object.created", "j2ee.object.deleted"};
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$WebModule == null ? (class$org$jboss$management$j2ee$WebModule = WebModule.class$("org.jboss.management.j2ee.WebModule")) : class$org$jboss$management$j2ee$WebModule));
    private List servlets = new ArrayList();
    private String jbossWebDD;
    private static final Map fakeJ2EEApps = new HashMap();
    static /* synthetic */ Class class$org$jboss$management$j2ee$WebModule;

    public static ObjectName create(MBeanServer mbeanServer, String earName, String warName, URL pURL, ObjectName webContainerName) {
        String lDD = null;
        String lJBossWebDD = null;
        ObjectName jsr77ParentName = null;
        ObjectName lCreated = null;
        ObjectName j2eeServerName = J2EEDomain.getDomainServerName(mbeanServer);
        ObjectName jsr77Name = null;
        try {
            Hashtable<String, String> props = j2eeServerName.getKeyPropertyList();
            String j2eeServer = props.get("j2eeType") + "=" + props.get("name");
            if (earName == null) {
                jsr77ParentName = j2eeServerName;
            } else {
                ObjectName lApplicationQuery = new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEApplication" + "," + "name=" + earName + "," + j2eeServer + "," + "*");
                Set<ObjectName> lApplications = mbeanServer.queryNames(lApplicationQuery, null);
                if (lApplications.isEmpty()) {
                    jsr77ParentName = lCreated = J2EEApplication.create(mbeanServer, earName, null);
                } else if (lApplications.size() == 1) {
                    jsr77ParentName = lApplications.iterator().next();
                }
            }
            lDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 1);
            lJBossWebDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 5);
        }
        catch (Exception e) {
            log.error((Object)("Could not create JSR-77 WebModule: " + warName), (Throwable)e);
            return null;
        }
        try {
            ObjectName[] jvms = (ObjectName[])mbeanServer.getAttribute(j2eeServerName, "JavaVMs");
            WebModule webModule = new WebModule(warName, jsr77ParentName, jvms, lDD, webContainerName, lJBossWebDD);
            jsr77Name = webModule.getObjectName();
            mbeanServer.registerMBean(webModule, jsr77Name);
            if (lCreated != null) {
                fakeJ2EEApps.put(jsr77Name, lCreated);
            }
            log.debug((Object)("Created JSR-77 WebModule: " + jsr77Name));
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 WebModule: " + warName), (Throwable)e);
            return null;
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, ObjectName jsr77Name) {
        try {
            mbeanServer.unregisterMBean(jsr77Name);
            log.debug((Object)("Remove JSR-77 WebModule: " + jsr77Name));
            ObjectName jsr77ParentName = (ObjectName)fakeJ2EEApps.get(jsr77Name);
            if (jsr77ParentName != null) {
                log.debug((Object)("Remove fake JSR-77 parent Application: " + jsr77ParentName));
                J2EEApplication.destroy(mbeanServer, jsr77ParentName);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 WebModule: " + jsr77Name), (Throwable)e);
        }
    }

    public WebModule(String warName, ObjectName j2eeAppName, ObjectName[] jvms, String webDD, ObjectName webContainerName, String jbossWebDD) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, warName, j2eeAppName, jvms, webDD);
        jbossWebDD = jbossWebDD == null ? "" : jbossWebDD;
    }

    public ObjectName[] getServlets() {
        ObjectName[] names = new ObjectName[this.servlets.size()];
        this.servlets.toArray(names);
        return names;
    }

    public ObjectName getServlet(int pIndex) {
        if (pIndex >= 0 && pIndex < this.servlets.size()) {
            return (ObjectName)this.servlets.get(pIndex);
        }
        return null;
    }

    public String getJBossWebDeploymentDescriptor() {
        return this.jbossWebDD;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("Servlet".equals(lType)) {
            this.servlets.add(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("Servlet".equals(lType)) {
            this.servlets.remove(pChild);
        }
    }

    public String[] getEventTypes() {
        return eventTypes;
    }

    public String getEventType(int index) {
        String type = null;
        if (index >= 0 && index < eventTypes.length) {
            type = eventTypes[index];
        }
        return type;
    }

    public void postCreation() {
        this.sendNotification("j2ee.object.created", "Web module created");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "Web module destroyed");
    }

    public String toString() {
        return "WebModule[ " + super.toString() + ", Servlets: " + this.servlets + ", JBoss-Web-DD: " + this.jbossWebDD + " ]";
    }

    protected Hashtable getParentKeys(ObjectName jsr77ParentName) {
        Hashtable<String, String> parentKeys = new Hashtable<String, String>();
        Hashtable<String, String> parentProps = jsr77ParentName.getKeyPropertyList();
        String parentName = parentProps.get("name");
        String j2eeType = parentProps.get("j2eeType");
        if (!j2eeType.equals("J2EEApplication")) {
            parentKeys.put("J2EEServer", parentName);
            parentKeys.put("J2EEApplication", "null");
        } else {
            parentKeys.put("J2EEApplication", parentName);
            String j2eeServerName = parentProps.get("J2EEServer");
            parentKeys.put("J2EEServer", j2eeServerName);
        }
        return parentKeys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

