/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import org.jboss.logging.Logger;

public class PortUtil {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$PortUtil == null ? (class$org$jboss$remoting$transport$PortUtil = PortUtil.class$("org.jboss.remoting.transport.PortUtil")) : class$org$jboss$remoting$transport$PortUtil));
    private static final int MIN_UNPRIVILEGED_PORT = 1024;
    private static final int MAX_LEGAL_PORT = 65535;
    private static int portCounter = 0;
    private static int retryMax = 50;
    static /* synthetic */ Class class$org$jboss$remoting$transport$PortUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkPort(int p, String host) {
        boolean available = true;
        ServerSocket socket = null;
        InetAddress inetAddress = InetAddress.getByName(host);
        socket = new ServerSocket(p, 0, inetAddress);
        Object var6_6 = null;
        if (socket == null) return available;
        try {
            socket.close();
            return available;
        }
        catch (IOException e2) {}
        return available;
        {
            catch (IOException e) {
                log.debug((Object)("port " + p + " already in use.  Will try another."));
                available = false;
                Object var6_7 = null;
                if (socket == null) return available;
                try {
                    socket.close();
                    return available;
                }
                catch (IOException e2) {}
                return available;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (socket == null) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static int findFreePort(String host) throws IOException {
        int tryCount;
        Integer port = null;
        for (tryCount = 0; port == null && tryCount < retryMax; ++tryCount) {
            port = PortUtil.getFreePort(host);
            if (port == null || PortUtil.checkPort(port, host)) continue;
            port = null;
        }
        if (tryCount >= retryMax) {
            throw new IOException("Can not find a free port for use.");
        }
        return port;
    }

    private static Integer getFreePort(String host) {
        int p = PortUtil.getNextPort();
        if (PortUtil.checkPort(p, host)) {
            return new Integer(p);
        }
        return null;
    }

    private static synchronized int getNextPort() {
        if (portCounter < 65535) {
            return portCounter++;
        }
        portCounter = 1024;
        return 65535;
    }

    public static int getRandomStartingPort() {
        Object o = new Object();
        String os = o.toString();
        os = os.substring(17);
        int n = Integer.parseInt(os, 16);
        int p = Math.abs(new SecureRandom(String.valueOf(System.currentTimeMillis() + (long)n).getBytes()).nextInt(2000)) + 2000;
        return p;
    }

    public static void main(String[] args) {
        try {
            System.out.println("port - " + PortUtil.findFreePort("localhost"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        portCounter = PortUtil.getRandomStartingPort();
    }
}

