/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.utility.StoppableThread;

public class InputMultiplexor {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$InputMultiplexor == null ? (class$org$jboss$remoting$transport$multiplex$InputMultiplexor = InputMultiplexor.class$("org.jboss.remoting.transport.multiplex.InputMultiplexor")) : class$org$jboss$remoting$transport$multiplex$InputMultiplexor));
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$InputMultiplexor;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$InputMultiplexor$InputThread;

    static InputThread getAnInputThread(MultiplexingManager manager, Socket socket, OutputStream os) throws IOException {
        return new InputThread(manager, socket, os);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class InputThread
    extends StoppableThread {
        private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$InputMultiplexor$InputThread == null ? (class$org$jboss$remoting$transport$multiplex$InputMultiplexor$InputThread = InputMultiplexor.class$("org.jboss.remoting.transport.multiplex.InputMultiplexor$InputThread")) : class$org$jboss$remoting$transport$multiplex$InputMultiplexor$InputThread));
        private static final int READING_DATA = 0;
        private static final int SAW_MARKER = 1;
        private static final int READING_ID = 2;
        private InputStream is;
        private OutputStream currentOutputStream;
        private ByteArrayOutputStream bos;
        private MultiplexingManager manager;
        private int state;
        private boolean managerShuttingDown = false;
        private int dataInCount = 0;
        private SocketId currentSocketId;
        private boolean tracing;

        public InputThread(MultiplexingManager manager, Socket socket, OutputStream os) throws IOException {
            this.is = new BufferedInputStream(socket.getInputStream());
            this.manager = manager;
            this.currentOutputStream = os;
            this.bos = new ByteArrayOutputStream();
            boolean state = false;
            this.tracing = log.isTraceEnabled();
        }

        public synchronized void shutdown() {
            super.shutdown();
            this.interrupt();
            this.managerShuttingDown = true;
            this.notify();
        }

        protected void doInit() {
            log.debug((Object)"input thread starting");
        }

        protected void doRun() {
            int b = 0;
            try {
                b = this.is.read();
                while (b >= 0 && this.isRunning()) {
                    if (this.tracing) {
                        log.trace((Object)("" + (0xFF & b)));
                    }
                    switch (this.state) {
                        case 0: {
                            if (b == 255) {
                                this.state = 1;
                                break;
                            }
                            try {
                                this.currentOutputStream.write(b);
                            }
                            catch (IOException e) {
                                log.debug((Object)("unable to write to PipedOutputStream (" + this.currentSocketId.getPort() + "): reading thread must have died"), (Throwable)e);
                                this.currentOutputStream = this.manager.getOutputStreamByLocalSocket(SocketId.DEADLETTER_SOCKET_ID);
                            }
                            ++this.dataInCount;
                            break;
                        }
                        case 1: {
                            if (b == 255) {
                                this.state = 0;
                                try {
                                    this.currentOutputStream.write(b);
                                }
                                catch (IOException e) {
                                    log.debug((Object)("unable to write to PipedOutputStream (" + this.currentSocketId.getPort() + ")"), (Throwable)e);
                                    this.currentOutputStream = this.manager.getOutputStreamByLocalSocket(SocketId.DEADLETTER_SOCKET_ID);
                                }
                                ++this.dataInCount;
                                break;
                            }
                            this.state = 2;
                            this.currentOutputStream.flush();
                            this.bos.reset();
                            this.bos.write(b);
                            break;
                        }
                        case 2: {
                            if (b == 255) {
                                this.state = 0;
                                this.currentSocketId = new SocketId(this.bos.toByteArray());
                                this.bos.reset();
                                this.currentOutputStream = this.manager.getOutputStreamByLocalSocket(this.currentSocketId);
                                if (this.tracing) {
                                    log.trace((Object)("redirecting input to socket: " + this.currentSocketId.getPort()));
                                }
                                if (this.currentOutputStream != null) break;
                                log.error((Object)("unknown socket id: " + this.currentSocketId.getPort()));
                                this.currentOutputStream = this.manager.getOutputStreamByLocalSocket(SocketId.DEADLETTER_SOCKET_ID);
                                break;
                            }
                            this.bos.write(b);
                        }
                    }
                    b = this.is.read();
                }
            }
            catch (InterruptedIOException e) {
                this.handleError("interrupted", e);
            }
            catch (IOException e) {
                this.handleError("i/o error", e);
            }
            super.shutdown();
            log.debug((Object)("last byte: " + b));
            log.debug((Object)("isRunning: " + this.isRunning()));
        }

        protected void doShutDown() {
            log.debug((Object)("input thread: data bytes read: " + this.dataInCount));
            this.flushPipes();
            this.stayAlive();
            log.debug((Object)"input thread shutting down");
        }

        protected void handleError(String error, Throwable e) {
            if (e instanceof InterruptedException || e instanceof IOException) {
                if (this.tracing) {
                    log.debug((Object)error, e);
                }
            } else {
                log.debug((Object)error, e);
            }
        }

        protected synchronized void stayAlive() {
            log.debug((Object)"input thread entering stayAlive()");
            while (!this.managerShuttingDown) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.debug((Object)"stayAlive(): InterruptedException");
                }
                log.debug((Object)"stayAlive(): wait ended");
            }
        }

        protected void flushPipes() {
            Iterator it = this.manager.getAllOutputStreams().iterator();
            while (it.hasNext()) {
                OutputStream os = (OutputStream)it.next();
                try {
                    os.flush();
                }
                catch (IOException ignored) {
                    log.error((Object)"unable to flush a PipedOutputStream");
                }
            }
        }
    }
}

