/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingDataInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.StoppableThread;

public class Protocol {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$Protocol == null ? (class$org$jboss$remoting$transport$multiplex$Protocol = Protocol.class$("org.jboss.remoting.transport.multiplex.Protocol")) : class$org$jboss$remoting$transport$multiplex$Protocol));
    public static final int MP_CONNECT = 0;
    public static final int MP_CONNECTED = 1;
    public static final int MP_VERIFY_CONNECTION = 2;
    public static final int MP_OUTPUT_SHUTDOWN = 4;
    public static final int MP_DISCONNECT = 5;
    public static final int MP_REGISTER_REMOTE_SERVER = 6;
    public static final int MP_UNREGISTER_REMOTE_SERVER = 7;
    public static final int MP_REQUEST_MANAGER_SHUTDOWN = 8;
    public static final int MP_ERROR = 9;
    public static final int MP_TRUE = 10;
    public static final int MP_FALSE = 11;
    private MultiplexingManager manager;
    private MultiplexingInputStream protocolMultiplexingInputStream;
    private DataInputStream protocolInputStream;
    private DataOutputStream protocolOutputStream;
    private DataOutputStream serverSocketOutputStream;
    private DataInputStream serverSocketInputStream;
    private DataInputStream backChannelInputStream;
    private MultiplexingOutputStream backChannelOutputStream;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$Protocol;

    public Protocol(MultiplexingManager manager) throws IOException {
        this.manager = manager;
        Socket socket = manager.getSocket();
        this.protocolMultiplexingInputStream = manager.getAnInputStream(SocketId.PROTOCOL_SOCKET_ID, null);
        this.protocolMultiplexingInputStream.setTimeout(10000);
        this.protocolInputStream = new DataInputStream(this.protocolMultiplexingInputStream);
        this.protocolOutputStream = new DataOutputStream(new MultiplexingOutputStream(manager, SocketId.PROTOCOL_SOCKET_ID));
        this.serverSocketOutputStream = new DataOutputStream(new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_ID));
        this.backChannelOutputStream = new MultiplexingOutputStream(manager, SocketId.BACKCHANNEL_SOCKET_ID);
        this.backChannelInputStream = new DataInputStream(manager.getAnInputStream(SocketId.BACKCHANNEL_SOCKET_ID, null));
    }

    public SocketId connect(MultiplexingDataInputStream is, SocketId socketId) throws IOException {
        return this.connect(is, socketId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketId connect(MultiplexingDataInputStream is, SocketId socketId, int timeout) throws IOException {
        log.debug((Object)"entering Protocol.connect()");
        long start = System.currentTimeMillis();
        int timeLeft = 0;
        int savedTimeout = is.getTimeout();
        DataOutputStream dataOutputStream = this.serverSocketOutputStream;
        synchronized (dataOutputStream) {
            this.serverSocketOutputStream.write(0);
            log.debug((Object)"Protocol.connect(): wrote: CONNECT (0)");
            this.serverSocketOutputStream.writeInt(socketId.getPort());
            log.debug((Object)("Protocol.connect(): wrote port: " + socketId.getPort()));
        }
        try {
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException();
            }
            is.setTimeout(timeLeft);
            int messageType = is.read();
            log.debug((Object)("Protocol.connect(): read message type: " + messageType));
            switch (messageType) {
                case 1: {
                    if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                        throw new SocketTimeoutException("connect timed out");
                    }
                    is.setTimeout(timeLeft);
                    int remotePort = is.readInt();
                    log.debug((Object)("Protocol.connect(): read port: " + remotePort));
                    SocketId socketId2 = new SocketId(remotePort);
                    return socketId2;
                }
            }
            try {
                log.error((Object)("Protocol.connect(): expecting a CONNECTED message: received: " + messageType));
                throw new IOException("Protocol.connect(): expecting a CONNECTED message: received: " + messageType);
            }
            catch (SocketTimeoutException e) {
                log.info((Object)"timeout in Protocol.connect()");
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e);
                e.printStackTrace();
                StackTraceElement[] stes = e.getStackTrace();
                for (int i = 0; i < stes.length; ++i) {
                    log.error((Object)stes[i].toString());
                }
                throw new IOException(e.getMessage());
            }
        }
        finally {
            is.setTimeout(savedTimeout);
        }
    }

    /*
     * Exception decompiling
     */
    public SocketId acceptConnect(MultiplexingDataInputStream is, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void answerConnect(DataOutputStream os, int port) throws IOException {
        os.write(1);
        log.debug((Object)"Protocol.answerConnect(): wrote: CONNECTED (1)");
        os.writeInt(port);
        log.debug((Object)("Protocol.answerConnect(): wrote port: " + port));
    }

    public void verifyConnect(OutputStream os) throws IOException {
        try {
            os.write(2);
            log.debug((Object)"verifyConnect(): wrote: VERIFY_CONNECTION (2)");
        }
        catch (IOException e) {
            log.error((Object)"i/o error in verifyConnect()");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnectVerification(MultiplexingDataInputStream is, int timeout) throws IOException {
        log.debug((Object)"entered getConnectVerification()");
        int savedTimeout = is.getTimeout();
        try {
            is.setTimeout(timeout);
            is.read();
            log.debug((Object)"getConnectVerification(): received response");
        }
        catch (SocketTimeoutException e) {
            log.info((Object)"timeout in Protocol.getConnectVerification()");
            throw e;
        }
        catch (IOException e) {
            log.error((Object)"i/o error in getConnectVerification()");
        }
        finally {
            is.setTimeout(savedTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOutputShutdown(SocketId socketId) {
        int port = socketId.getPort();
        try {
            MultiplexingOutputStream multiplexingOutputStream = this.backChannelOutputStream;
            synchronized (multiplexingOutputStream) {
                this.backChannelOutputStream.write(4, port);
                this.backChannelOutputStream.writeInt(port, port);
            }
            log.debug((Object)("Protocol.notifyOutputShutdown(): wrote: OUTPUT_SHUTDOWN (4) for port: " + port));
        }
        catch (IOException ignored) {
            log.error((Object)("Protocol.notifyOutputShutdown(): unable to send MP_OUTPUT_SHUTDOWN message to port: " + port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(SocketId socketId) {
        int port = socketId.getPort();
        try {
            MultiplexingOutputStream multiplexingOutputStream = this.backChannelOutputStream;
            synchronized (multiplexingOutputStream) {
                this.backChannelOutputStream.write(5, port);
                this.backChannelOutputStream.writeInt(port, port);
            }
            log.debug((Object)("Protocol.disconnect(): wrote: DISCONNECT (1) for port: " + port));
        }
        catch (IOException ignored) {
            log.error((Object)("Protocol.disconnect(): unable to send DISCONNECT message to port: " + port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemoteServerSocket(int timeout) throws IOException {
        int answer = 11;
        DataInputStream dataInputStream = this.protocolInputStream;
        synchronized (dataInputStream) {
            MultiplexingOutputStream multiplexingOutputStream = this.backChannelOutputStream;
            synchronized (multiplexingOutputStream) {
                this.backChannelOutputStream.write(6);
            }
            log.debug((Object)"Protocol.registerRemoteServerSocket(): wrote: REGISTER_REMOTE_SERVER (6)");
            int savedTimeout = this.protocolMultiplexingInputStream.getTimeout();
            this.protocolMultiplexingInputStream.setTimeout(timeout);
            try {
                answer = this.protocolInputStream.read();
            }
            finally {
                this.protocolMultiplexingInputStream.setTimeout(savedTimeout);
            }
        }
        log.debug((Object)("Protocol.registerRemoteServerSocket(): read: " + (answer == 10 ? "true" : "false")));
        if (answer == 11) {
            throw new IOException("unable to register remote socket");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRemoteServerSocket() {
        try {
            MultiplexingOutputStream multiplexingOutputStream = this.backChannelOutputStream;
            synchronized (multiplexingOutputStream) {
                this.backChannelOutputStream.write(7);
            }
            log.debug((Object)"Protocol.disconnect(): wrote: UNREGISTER_REMOTE_SERVER (7)");
        }
        catch (IOException ignored) {
            log.error((Object)"Protocol.unregisterRemoteServerSocket(): unable to send UNREGISTER_REMOTE_SERVER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestManagerShutdown() throws IOException {
        int b;
        DataInputStream dataInputStream = this.protocolInputStream;
        synchronized (dataInputStream) {
            MultiplexingOutputStream multiplexingOutputStream = this.backChannelOutputStream;
            synchronized (multiplexingOutputStream) {
                this.backChannelOutputStream.write(8, -1);
            }
            log.debug((Object)"Protocol.requestManagerShutdown(): wrote: REQUEST_MANAGER_SHUTDOWN (8)");
            b = this.protocolInputStream.read();
        }
        boolean answer = b == 10;
        log.debug((Object)("Protocol.requestManagerShutdown(): read: " + answer));
        return answer;
    }

    public BackChannelThread getBackChannelThread() {
        return new BackChannelThread(this.manager, this.backChannelInputStream);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class BackChannelThread
    extends StoppableThread {
        private MultiplexingManager manager;
        private DataInputStream is;

        public BackChannelThread(MultiplexingManager manager, DataInputStream is) {
            this.manager = manager;
            this.is = is;
        }

        public void shutdown() {
            log.debug((Object)"back channel thread: beginning shut down");
            super.shutdown();
            this.interrupt();
        }

        protected void doInit() {
            log.debug((Object)"back channel thread starting");
        }

        protected void doRun() {
            try {
                int messageType = this.is.read();
                log.debug((Object)("back channel thread: read message type: " + messageType));
                switch (messageType) {
                    case 4: {
                        int port = this.is.readInt();
                        log.debug((Object)("back channel thread: read OUTPUT_SHUTDOWN for port: " + port));
                        VirtualSocket socket = this.manager.getSocketByLocalPort(new SocketId(port));
                        if (socket == null) {
                            log.info((Object)("back channel thread (OUTPUT_SHUTDOWN): unable to retrieve socket at port: " + port));
                            break;
                        }
                        socket.handleRemoteOutputShutDown();
                        break;
                    }
                    case 5: {
                        int port = this.is.readInt();
                        log.debug((Object)("back channel thread: read DISCONNECT for port: " + port));
                        VirtualSocket socket = this.manager.getSocketByLocalPort(new SocketId(port));
                        if (socket == null) {
                            log.info((Object)("back channel thread (DISCONNECT): unable to retrieve socket at port: " + port));
                            break;
                        }
                        socket.handleRemoteDisconnect();
                        break;
                    }
                    case 6: {
                        log.debug((Object)"back channel thread: read REGISTER_REMOTE_SERVER");
                        int answer = 10;
                        try {
                            this.manager.registerRemoteServerSocket();
                        }
                        catch (Exception e) {
                            answer = 11;
                            log.info((Object)"back channel thread: unable to register remote server");
                        }
                        Protocol.this.protocolOutputStream.write(answer);
                        break;
                    }
                    case 7: {
                        log.debug((Object)"back channel thread: read UNREGISTER_REMOTE_SERVER");
                        this.manager.unRegisterRemoteServerSocket();
                        break;
                    }
                    case 8: {
                        log.debug((Object)"back channel thread: read REQUEST_MANAGER_SHUTDOWN");
                        int answer = this.manager.respondToShutdownRequest() ? 10 : 11;
                        log.debug((Object)("back channel thread: writing " + answer));
                        Protocol.this.protocolOutputStream.write(answer);
                        break;
                    }
                    default: {
                        log.error((Object)("unexpected message type in back channel thread: " + messageType));
                        break;
                    }
                }
            }
            catch (InterruptedIOException e) {
                if (this.isRunning()) {
                    log.error((Object)"back channel thread: i/o interruption", (Throwable)e);
                } else {
                    log.debug((Object)"back channel thread: i/o interruption");
                }
            }
            catch (IOException e) {
                if (this.isRunning()) {
                    log.error((Object)"back channel thread: i/o error", (Throwable)e);
                    this.running = false;
                }
                log.debug((Object)"back channel thread: i/o error");
            }
        }

        protected void doShutDown() {
            log.debug((Object)"back channel thread shutting down");
        }
    }
}

