/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.serializable;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.PreferredStreamUnMarshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class SerializableUnMarshaller
implements PreferredStreamUnMarshaller,
VersionedUnMarshaller {
    static final long serialVersionUID = -1554017376768780738L;
    public static final String DATATYPE = "serializable";
    protected ClassLoader customClassLoader = null;
    protected String serializationType;

    public InputStream getMarshallingStream(InputStream inputStream) throws IOException {
        return this.getMarshallingStream(inputStream, null);
    }

    public InputStream getMarshallingStream(InputStream inputStream, Map config) throws IOException {
        if (inputStream instanceof ObjectInputStream) {
            return inputStream;
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        SerializationManager manager = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
        return manager.createInput(bis, this.customClassLoader);
    }

    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        int version = Version.getDefaultVersion();
        return this.read(inputStream, metadata, version);
    }

    public Object read(InputStream inputStream, Map metadata, int version) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = (ObjectInputStream)this.getMarshallingStream(inputStream, null);
        return SerializationStreamFactory.getManagerInstance(this.getSerializationType()).receiveObject(ois, this.customClassLoader, version);
    }

    public void setClassLoader(ClassLoader classloader) {
        this.customClassLoader = classloader;
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        SerializableUnMarshaller unmarshaller = new SerializableUnMarshaller();
        unmarshaller.setClassLoader(this.customClassLoader);
        return unmarshaller;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public String getSerializationType() {
        if (this.serializationType == null) {
            return "java";
        }
        return this.serializationType;
    }
}

