/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.interceptor.Interceptors;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.ClassValidator;
import org.jboss.seam.ComponentType;
import org.jboss.seam.InstantiationException;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.RequiredException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Around;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.DataBinderClass;
import org.jboss.seam.annotations.DataSelectorClass;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.IfInvalid;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.JndiName;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Mutable;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.RequestParameter;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.Within;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.databinding.DataBinder;
import org.jboss.seam.databinding.DataSelector;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.BusinessProcessInterceptor;
import org.jboss.seam.interceptors.ConversationInterceptor;
import org.jboss.seam.interceptors.Interceptor;
import org.jboss.seam.interceptors.JavaBeanInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.interceptors.RemoveInterceptor;
import org.jboss.seam.interceptors.RollbackInterceptor;
import org.jboss.seam.interceptors.TransactionInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.LogImpl;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.SetPropertyEditor;
import org.jboss.seam.util.SortItem;
import org.jboss.seam.util.SorterNew;
import org.jboss.seam.util.StringArrayPropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
public class Component {
    public static final String PROPERTIES = "org.jboss.seam.properties";
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(Component.class);
    private ComponentType type;
    private String name;
    private ScopeType scope;
    private Class<?> beanClass;
    private String jndiName;
    private InterceptionType interceptionType;
    private boolean startup;
    private String[] dependencies;
    private boolean mutable;
    private Method destroyMethod;
    private Method createMethod;
    private Method unwrapMethod;
    private Set<Method> removeMethods;
    private Set<Method> validateMethods;
    private Set<Method> inMethods;
    private Set<Field> inFields;
    private Set<Method> outMethods;
    private Set<Field> outFields;
    private Set<Field> parameterFields;
    private Set<Method> parameterSetters;
    private Map<Method, Object> initializers;
    private List<Method> dataModelGetters;
    private Map<Method, Annotation> dataModelGetterAnnotations;
    private Map<String, Method> dataModelSelectionSetters;
    private Map<Method, Annotation> dataModelSelectionSetterAnnotations;
    private List<Field> dataModelFields;
    private Map<Field, Annotation> dataModelFieldAnnotations;
    private Map<String, Field> dataModelSelectionFields;
    private Map<Field, Annotation> dataModelSelectionFieldAnnotations;
    private Field logField;
    private Log logInstance;
    private Hashtable<Locale, ClassValidator> validators;
    private List<Interceptor> interceptors;
    private Set<Class> businessInterfaces;
    private Class<net.sf.cglib.proxy.Factory> factory;

    public Component(Class<?> clazz) {
        this(clazz, Seam.getComponentName(clazz));
    }

    public Component(Class<?> clazz, String componentName) {
        this(clazz, componentName, Seam.getComponentScope(clazz));
    }

    public Component(Class<?> clazz, String componentName, ScopeType componentScope) {
        this(clazz, componentName, componentScope, Contexts.getApplicationContext());
    }

    public Component(Class<?> clazz, Context applicationContext) {
        this(clazz, Seam.getComponentName(clazz), Seam.getComponentScope(clazz), applicationContext);
    }

    public Component(Class<?> clazz, String componentName, ScopeType componentScope, Context applicationContext) {
        PropertyEditorManager.registerEditor(String[].class, StringArrayPropertyEditor.class);
        PropertyEditorManager.registerEditor(Set.class, SetPropertyEditor.class);
        this.removeMethods = new HashSet<Method>();
        this.validateMethods = new HashSet<Method>();
        this.inMethods = new HashSet<Method>();
        this.inFields = new HashSet<Field>();
        this.outMethods = new HashSet<Method>();
        this.outFields = new HashSet<Field>();
        this.parameterFields = new HashSet<Field>();
        this.parameterSetters = new HashSet<Method>();
        this.initializers = new HashMap<Method, Object>();
        this.dataModelGetters = new ArrayList<Method>();
        this.dataModelGetterAnnotations = new HashMap<Method, Annotation>();
        this.dataModelSelectionSetters = new HashMap<String, Method>();
        this.dataModelSelectionSetterAnnotations = new HashMap<Method, Annotation>();
        this.dataModelFields = new ArrayList<Field>();
        this.dataModelFieldAnnotations = new HashMap<Field, Annotation>();
        this.dataModelSelectionFields = new HashMap<String, Field>();
        this.dataModelSelectionFieldAnnotations = new HashMap<Field, Annotation>();
        this.validators = new Hashtable();
        this.interceptors = new ArrayList<Interceptor>();
        this.beanClass = clazz;
        this.name = componentName;
        this.scope = componentScope;
        this.type = Seam.getComponentType(this.beanClass);
        this.interceptionType = Seam.getInterceptionType(this.beanClass);
        this.checkScopeForComponentType();
        this.startup = this.beanClass.isAnnotationPresent(Startup.class);
        if (this.startup) {
            this.dependencies = this.getBeanClass().getAnnotation(Startup.class).depends();
        }
        this.mutable = this.beanClass.isAnnotationPresent(Mutable.class);
        if (this.mutable) {
            Init.instance().getMutableComponentNames().add(this.name);
        }
        this.jndiName = this.getJndiName(applicationContext);
        log.info((Object)("Component: " + this.getName() + ", scope: " + (Object)((Object)this.getScope()) + ", type: " + (Object)((Object)this.getType()) + ", class: " + this.beanClass.getName() + (this.jndiName == null ? "" : ", JNDI: " + this.jndiName)));
        this.initMembers(clazz, applicationContext);
        this.checkDestroyMethod();
        this.businessInterfaces = Component.getBusinessInterfaces(this.beanClass);
        if (this.interceptionType != InterceptionType.NEVER) {
            this.initInterceptors();
        }
        this.initInitializers(applicationContext);
        if (this.type == ComponentType.JAVA_BEAN) {
            this.factory = this.createProxyFactory();
        }
    }

    private void checkScopeForComponentType() {
        boolean serializableType;
        if (this.scope == ScopeType.STATELESS && (this.type == ComponentType.STATEFUL_SESSION_BEAN || this.type == ComponentType.ENTITY_BEAN)) {
            throw new IllegalArgumentException("Only stateless session beans and Java beans may be bound to the STATELESS context: " + this.name);
        }
        if (this.scope == ScopeType.PAGE && this.type == ComponentType.STATEFUL_SESSION_BEAN) {
            throw new IllegalArgumentException("Stateful session beans may not be bound to the PAGE context: " + this.name);
        }
        if (this.scope == ScopeType.APPLICATION && this.type == ComponentType.STATEFUL_SESSION_BEAN) {
            log.warn((Object)("Stateful session beans was bound to the APPLICATION context - note that it is not safe to make concurrent calls to the bean: " + this.name));
        }
        if (this.scope != ScopeType.STATELESS && this.type == ComponentType.MESSAGE_DRIVEN_BEAN) {
            throw new IllegalArgumentException("Message-driven beans must be bound to STATELESS context: " + this.name);
        }
        boolean serializableScope = this.scope == ScopeType.PAGE || this.scope == ScopeType.SESSION || this.scope == ScopeType.CONVERSATION;
        boolean bl = serializableType = this.type == ComponentType.JAVA_BEAN || this.type == ComponentType.ENTITY_BEAN;
        if (serializableType && serializableScope && !Serializable.class.isAssignableFrom(this.beanClass)) {
            log.warn((Object)("Component class should be serializable: " + this.name));
        }
    }

    private void checkDestroyMethod() {
        if (!(this.type != ComponentType.STATEFUL_SESSION_BEAN || this.destroyMethod != null && this.removeMethods.contains(this.destroyMethod))) {
            throw new IllegalArgumentException("Stateful session bean component should have a method marked @Remove @Destroy: " + this.name);
        }
    }

    private String getJndiName(Context applicationContext) {
        if (this.beanClass.isAnnotationPresent(JndiName.class)) {
            return this.beanClass.getAnnotation(JndiName.class).value();
        }
        switch (this.type) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return null;
            }
        }
        if (applicationContext == null) {
            return null;
        }
        String jndiPattern = Init.instance().getJndiPattern();
        if (jndiPattern == null) {
            throw new IllegalArgumentException("You must specify org.jboss.seam.core.init.jndiPattern or use @JndiName: " + this.name);
        }
        return jndiPattern.replace("#{ejbName}", Seam.getEjbName(this.beanClass));
    }

    private void initInitializers(Context applicationContext) {
        if (applicationContext == null) {
            return;
        }
        Map properties = (Map)applicationContext.get(PROPERTIES);
        if (properties == null) {
            return;
        }
        for (Map.Entry me : properties.entrySet()) {
            PropertyDescriptor propertyDescriptor;
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            if (!key.startsWith(this.name) || key.charAt(this.name.length()) != '.') continue;
            if (this.type == ComponentType.ENTITY_BEAN) {
                throw new IllegalArgumentException("can not configure entity beans: " + this.name);
            }
            if (this.type != ComponentType.JAVA_BEAN && this.businessInterfaces.size() > 1) {
                throw new IllegalArgumentException("can only configure components with exactly one business interface: " + this.name);
            }
            Class configClass = this.type == ComponentType.JAVA_BEAN ? this.beanClass : this.businessInterfaces.iterator().next();
            String propertyName = key.substring(this.name.length() + 1, key.length());
            try {
                propertyDescriptor = new PropertyDescriptor(propertyName, configClass);
            }
            catch (IntrospectionException ie) {
                throw new IllegalArgumentException("no property for configuration setting: " + key, ie);
            }
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(propertyDescriptor.getPropertyType());
            propertyEditor.setAsText(value);
            this.initializers.put(propertyDescriptor.getWriteMethod(), propertyEditor.getValue());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(key + "=" + value));
        }
    }

    private void initMembers(Class<?> clazz, Context applicationContext) {
        Annotation ann;
        ArrayList<Method> selectionSetters = new ArrayList<Method>();
        ArrayList<AccessibleObject> selectionFields = new ArrayList<AccessibleObject>();
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                Init init;
                if (method.isAnnotationPresent(IfInvalid.class)) {
                    this.validateMethods.add(method);
                }
                if (method.isAnnotationPresent(Remove.class)) {
                    this.removeMethods.add(method);
                }
                if (method.isAnnotationPresent(Destroy.class)) {
                    if (this.type != ComponentType.JAVA_BEAN && this.type != ComponentType.STATEFUL_SESSION_BEAN) {
                        throw new IllegalArgumentException("Only JavaBeans and stateful session beans support @Destroy methods: " + this.name);
                    }
                    if (this.destroyMethod != null) {
                        throw new IllegalStateException("component has two @Destroy methods: " + this.name);
                    }
                    this.destroyMethod = method;
                }
                if (method.isAnnotationPresent(Create.class)) {
                    if (this.type != ComponentType.JAVA_BEAN && this.type != ComponentType.STATEFUL_SESSION_BEAN) {
                        throw new IllegalArgumentException("Only JavaBeans and stateful session beans support @Create methods: " + this.name);
                    }
                    if (this.createMethod != null) {
                        throw new IllegalStateException("component has two @Create methods: " + this.name);
                    }
                    this.createMethod = method;
                }
                if (method.isAnnotationPresent(In.class)) {
                    this.inMethods.add(method);
                }
                if (method.isAnnotationPresent(Out.class)) {
                    this.outMethods.add(method);
                }
                if (method.isAnnotationPresent(Unwrap.class)) {
                    if (this.unwrapMethod != null) {
                        throw new IllegalStateException("component has two @Unwrap methods: " + this.name);
                    }
                    this.unwrapMethod = method;
                }
                if (method.isAnnotationPresent(DataModel.class)) {
                    this.checkDataModelScope(method.getAnnotation(DataModel.class));
                }
                if (method.isAnnotationPresent(Factory.class)) {
                    init = (Init)applicationContext.get(Seam.getComponentName(Init.class));
                    String contextVariable = Component.toName(method.getAnnotation(Factory.class).value(), method);
                    init.addFactoryMethod(contextVariable, method, this);
                }
                if (method.isAnnotationPresent(Observer.class)) {
                    init = (Init)applicationContext.get(Seam.getComponentName(Init.class));
                    for (String eventType : method.getAnnotation(Observer.class).value()) {
                        if (eventType.length() == 0) {
                            eventType = method.getName();
                        }
                        init.addObserverMethod(eventType, method, this);
                    }
                }
                if (method.isAnnotationPresent(RequestParameter.class)) {
                    this.parameterSetters.add(method);
                }
                for (Annotation ann2 : method.getAnnotations()) {
                    if (ann2.annotationType().isAnnotationPresent(DataBinderClass.class)) {
                        this.dataModelGetters.add(method);
                        this.dataModelGetterAnnotations.put(method, ann2);
                    }
                    if (!ann2.annotationType().isAnnotationPresent(DataSelectorClass.class)) continue;
                    selectionSetters.add(method);
                    this.dataModelSelectionSetterAnnotations.put(method, ann2);
                }
                if (method.isAccessible()) continue;
                method.setAccessible(true);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                if (accessibleObject.isAnnotationPresent(In.class)) {
                    this.inFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(Out.class)) {
                    this.outFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(DataModel.class)) {
                    this.checkDataModelScope(((Field)accessibleObject).getAnnotation(DataModel.class));
                }
                if (accessibleObject.isAnnotationPresent(RequestParameter.class)) {
                    this.parameterFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(Logger.class)) {
                    this.logField = accessibleObject;
                    String category = ((Field)accessibleObject).getAnnotation(Logger.class).value();
                    this.logInstance = "".equals(category) ? new LogImpl(this.beanClass) : new LogImpl(category);
                }
                for (Annotation ann3 : accessibleObject.getAnnotations()) {
                    if (ann3.annotationType().isAnnotationPresent(DataBinderClass.class)) {
                        this.dataModelFields.add((Field)accessibleObject);
                        this.dataModelFieldAnnotations.put((Field)accessibleObject, ann3);
                    }
                    if (!ann3.annotationType().isAnnotationPresent(DataSelectorClass.class)) continue;
                    selectionFields.add(accessibleObject);
                    this.dataModelSelectionFieldAnnotations.put((Field)accessibleObject, ann3);
                }
                if (accessibleObject.isAccessible()) continue;
                ((Field)accessibleObject).setAccessible(true);
            }
            clazz = clazz.getSuperclass();
        }
        boolean hasMultipleDataModels = this.dataModelGetters.size() + this.dataModelFields.size() > 1;
        String defaultDataModelName = null;
        if (!hasMultipleDataModels) {
            String name;
            if (!this.dataModelGetters.isEmpty()) {
                Method dataModelGetter = this.dataModelGetters.get(0);
                Annotation annotation = this.dataModelGetterAnnotations.get(dataModelGetter);
                name = Component.createWrapper(annotation).getVariableName(annotation);
                defaultDataModelName = Component.toName(name, dataModelGetter);
            } else if (!this.dataModelFields.isEmpty()) {
                Field dataModelField = this.dataModelFields.get(0);
                Annotation annotation = this.dataModelFieldAnnotations.get(dataModelField);
                name = Component.createWrapper(annotation).getVariableName(annotation);
                defaultDataModelName = Component.toName(name, dataModelField);
            }
        }
        for (Method method : selectionSetters) {
            Method existing;
            ann = this.dataModelSelectionSetterAnnotations.get(method);
            String name = Component.createUnwrapper(ann).getVariableName(ann);
            if (name.length() == 0) {
                if (hasMultipleDataModels) {
                    throw new IllegalStateException("Missing value() for @DataModelSelection with multiple @DataModels");
                }
                name = defaultDataModelName;
            }
            if ((existing = this.dataModelSelectionSetters.put(name, method)) == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelection setters for: " + name);
        }
        for (Field field : selectionFields) {
            Field existing;
            ann = this.dataModelSelectionFieldAnnotations.get(field);
            String name = Component.createUnwrapper(ann).getVariableName(ann);
            if (name.length() == 0) {
                if (hasMultipleDataModels) {
                    throw new IllegalStateException("Missing value() for @DataModelSelection with multiple @DataModels");
                }
                name = defaultDataModelName;
            }
            if ((existing = this.dataModelSelectionFields.put(name, field)) == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelection fields for: " + name);
        }
    }

    private void checkDataModelScope(DataModel dataModel) {
        ScopeType dataModelScope = dataModel.scope();
        if (dataModelScope != ScopeType.PAGE && dataModelScope != ScopeType.UNSPECIFIED) {
            throw new IllegalArgumentException("@DataModel scope must be ScopeType.UNSPECIFIED or ScopeType.PAGE: " + this.name);
        }
    }

    private void initInterceptors() {
        this.initDefaultInterceptors();
        for (Annotation annotation : this.beanClass.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Interceptors.class)) continue;
            this.interceptors.add(new Interceptor(annotation, this));
        }
        this.newSort(this.interceptors);
        log.trace((Object)("interceptor stack: " + this.interceptors));
    }

    private List<Interceptor> newSort(List<Interceptor> list) {
        List siList = new ArrayList();
        HashMap ht = new HashMap();
        for (Interceptor interceptor : list) {
            SortItem<Interceptor> sortItem = new SortItem<Interceptor>(interceptor);
            siList.add(sortItem);
            ht.put(interceptor.getUserInterceptor().getClass(), sortItem);
        }
        for (SortItem sortItem : siList) {
            Class<?> clazz = ((Interceptor)sortItem.getObj()).getUserInterceptor().getClass();
            Around around = clazz.getAnnotation(Around.class);
            Within within = clazz.getAnnotation(Within.class);
            if (around != null) {
                for (Class cl : Arrays.asList(around.value())) {
                    sortItem.getAround().add((SortItem)ht.get(cl));
                }
            }
            if (within == null) continue;
            for (Class cl : Arrays.asList(within.value())) {
                sortItem.getWithin().add((SortItem)ht.get(cl));
            }
        }
        SorterNew sList = new SorterNew();
        siList = sList.sort(siList);
        list.clear();
        for (SortItem sortItem : siList) {
            list.add((Interceptor)sortItem.getObj());
        }
        return list;
    }

    private void initDefaultInterceptors() {
        this.interceptors.add(new Interceptor(new OutcomeInterceptor(), this));
        this.interceptors.add(new Interceptor(new RemoveInterceptor(), this));
        this.interceptors.add(new Interceptor(new BusinessProcessInterceptor(), this));
        this.interceptors.add(new Interceptor(new ConversationInterceptor(), this));
        this.interceptors.add(new Interceptor(new BijectionInterceptor(), this));
        this.interceptors.add(new Interceptor(new ValidationInterceptor(), this));
        this.interceptors.add(new Interceptor(new RollbackInterceptor(), this));
        if (this.getType() == ComponentType.JAVA_BEAN) {
            this.interceptors.add(new Interceptor(new TransactionInterceptor(), this));
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getName() {
        return this.name;
    }

    public ComponentType getType() {
        return this.type;
    }

    public ScopeType getScope() {
        return this.scope;
    }

    public ClassValidator getValidator() {
        java.util.ResourceBundle bundle = Contexts.isApplicationContextActive() ? ResourceBundle.instance() : null;
        Locale locale = bundle == null ? new Locale("DUMMY") : bundle.getLocale();
        ClassValidator validator = this.validators.get(locale);
        if (validator == null) {
            validator = bundle == null ? new ClassValidator(this.beanClass) : new ClassValidator(this.beanClass, bundle);
            this.validators.put(locale, validator);
        }
        return validator;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public Method getDestroyMethod() {
        return this.destroyMethod;
    }

    public Set<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public Set<Method> getValidateMethods() {
        return this.validateMethods;
    }

    public boolean hasDestroyMethod() {
        return this.destroyMethod != null;
    }

    public boolean hasCreateMethod() {
        return this.createMethod != null;
    }

    public Method getCreateMethod() {
        return this.createMethod;
    }

    public boolean hasUnwrapMethod() {
        return this.unwrapMethod != null;
    }

    public Method getUnwrapMethod() {
        return this.unwrapMethod;
    }

    public Set<Field> getOutFields() {
        return this.outFields;
    }

    public Set<Method> getOutMethods() {
        return this.outMethods;
    }

    public Set<Method> getInMethods() {
        return this.inMethods;
    }

    public Set<Field> getInFields() {
        return this.inFields;
    }

    public Object newInstance() {
        log.debug((Object)("instantiating Seam component: " + this.name));
        try {
            return this.initialize(this.instantiate());
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate Seam component: " + this.name, e);
        }
    }

    public boolean needsInjection() {
        return !this.getInFields().isEmpty() || !this.getInMethods().isEmpty() || !this.dataModelSelectionSetters.isEmpty() || !this.dataModelSelectionFields.isEmpty() || !this.parameterFields.isEmpty() || !this.parameterSetters.isEmpty() || this.logField != null;
    }

    public boolean needsOutjection() {
        return !this.getOutFields().isEmpty() || !this.getOutMethods().isEmpty() || !this.dataModelGetters.isEmpty() || !this.dataModelFields.isEmpty();
    }

    protected Object instantiate() throws Exception {
        switch (this.type) {
            case JAVA_BEAN: {
                if (this.interceptionType == InterceptionType.NEVER) {
                    return this.beanClass.newInstance();
                }
                net.sf.cglib.proxy.Factory bean = this.factory.newInstance();
                bean.setCallback(0, (Callback)new JavaBeanInterceptor());
                return bean;
            }
            case ENTITY_BEAN: {
                return this.beanClass.newInstance();
            }
            case STATELESS_SESSION_BEAN: 
            case STATEFUL_SESSION_BEAN: {
                return Naming.getInitialContext().lookup(this.jndiName);
            }
            case MESSAGE_DRIVEN_BEAN: {
                throw new UnsupportedOperationException("Message-driven beans may not be called: " + this.name);
            }
        }
        throw new IllegalStateException();
    }

    protected Object initialize(Object bean) throws Exception {
        for (Map.Entry<Method, Object> me : this.initializers.entrySet()) {
            Reflections.invoke(me.getKey(), bean, me.getValue());
        }
        return bean;
    }

    public void inject(Object bean) {
        this.injectLog(bean);
        this.injectMethods(bean);
        this.injectFields(bean);
        this.injectDataModelSelection(bean);
        this.injectParameters(bean);
    }

    private void injectLog(Object bean) {
        if (this.logField != null) {
            this.setFieldValue(bean, this.logField, "log", this.logInstance);
        }
    }

    private void injectParameters(Object bean) {
        Object convertedValue;
        String name;
        Map requestParameters = Component.getRequestParameters();
        for (Method setter : this.parameterSetters) {
            name = Component.toName(setter.getAnnotation(RequestParameter.class).value(), setter);
            convertedValue = Component.convertRequestParameter(requestParameters.get(name), setter.getParameterTypes()[0]);
            this.setPropertyValue(bean, setter, name, convertedValue);
        }
        for (Field field : this.parameterFields) {
            name = Component.toName(field.getAnnotation(RequestParameter.class).value(), field);
            convertedValue = Component.convertRequestParameter(requestParameters.get(name), field.getType());
            this.setFieldValue(bean, field, name, convertedValue);
        }
    }

    public static Map getRequestParameters() {
        Map requestParameters = null;
        if (FacesContext.getCurrentInstance() != null) {
            requestParameters = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        } else if (Lifecycle.getServletRequest() != null) {
            requestParameters = Lifecycle.getServletRequest().getParameterMap();
        }
        return requestParameters;
    }

    public static Object convertRequestParameter(Object requestParameter, Class type) {
        if (String.class.equals((Object)type)) {
            return requestParameter;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Converter converter = facesContext.getApplication().createConverter(type);
        if (converter == null) {
            throw new IllegalArgumentException("no converter for type: " + type);
        }
        return converter.getAsObject(facesContext, (UIComponent)facesContext.getViewRoot(), (String)requestParameter);
    }

    public void outject(Object bean) {
        this.outjectMethods(bean);
        this.outjectFields(bean);
        this.outjectDataModels(bean);
    }

    private void injectDataModelSelection(Object bean) {
        String name;
        DataBinder wrapper;
        Annotation dataModelAnn;
        for (Method dataModelGetter : this.dataModelGetters) {
            dataModelAnn = this.dataModelGetterAnnotations.get(dataModelGetter);
            wrapper = Component.createWrapper(dataModelAnn);
            name = Component.toName(wrapper.getVariableName(dataModelAnn), dataModelGetter);
            this.injectDataModelSelection(bean, name, null, wrapper, dataModelAnn);
        }
        for (Field dataModelField : this.dataModelFields) {
            dataModelAnn = this.dataModelFieldAnnotations.get(dataModelField);
            wrapper = Component.createWrapper(dataModelAnn);
            name = Component.toName(wrapper.getVariableName(dataModelAnn), dataModelField);
            this.injectDataModelSelection(bean, name, dataModelField, wrapper, dataModelAnn);
        }
    }

    private void injectDataModelSelection(Object bean, String name, Field dataModelField, DataBinder wrapper, Annotation dataModelAnn) {
        ScopeType scope = wrapper.getVariableScope(dataModelAnn);
        Object dataModel = this.getDataModelContext(scope).get(name);
        if (dataModel != null) {
            if (dataModelField != null) {
                this.setFieldValue(bean, dataModelField, name, wrapper.getWrappedData(dataModelAnn, dataModel));
            }
            Object selectedIndex = wrapper.getSelection(dataModelAnn, dataModel);
            log.debug((Object)("selected row: " + selectedIndex));
            if (selectedIndex != null) {
                Field field;
                Method setter = this.dataModelSelectionSetters.get(name);
                if (setter != null) {
                    Annotation dataModelSelectionAnn = this.dataModelSelectionSetterAnnotations.get(setter);
                    Object selection = Component.createUnwrapper(dataModelSelectionAnn).getSelection(dataModelSelectionAnn, dataModel);
                    this.setPropertyValue(bean, setter, name, selection);
                }
                if ((field = this.dataModelSelectionFields.get(name)) != null) {
                    Annotation dataModelSelectionAnn = this.dataModelSelectionFieldAnnotations.get(field);
                    Object selection = Component.createUnwrapper(dataModelSelectionAnn).getSelection(dataModelSelectionAnn, dataModel);
                    this.setFieldValue(bean, field, name, selection);
                }
            }
        }
    }

    private void outjectDataModels(Object bean) {
        Object list;
        String name;
        DataBinder wrapper;
        Annotation dataModelAnn;
        for (Method dataModelGetter : this.dataModelGetters) {
            dataModelAnn = this.dataModelGetterAnnotations.get(dataModelGetter);
            wrapper = Component.createWrapper(dataModelAnn);
            name = Component.toName(wrapper.getVariableName(dataModelAnn), dataModelGetter);
            list = this.getPropertyValue(bean, dataModelGetter, name);
            this.outjectDataModelList(name, list, wrapper, dataModelAnn);
        }
        for (Field dataModelField : this.dataModelFields) {
            dataModelAnn = this.dataModelFieldAnnotations.get(dataModelField);
            wrapper = Component.createWrapper(dataModelAnn);
            name = Component.toName(wrapper.getVariableName(dataModelAnn), dataModelField);
            list = this.getFieldValue(bean, dataModelField, name);
            this.outjectDataModelList(name, list, wrapper, dataModelAnn);
        }
    }

    private static DataBinder createWrapper(Annotation dataModelAnn) {
        try {
            return dataModelAnn.annotationType().getAnnotation(DataBinderClass.class).value().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static DataSelector createUnwrapper(Annotation dataModelAnn) {
        try {
            return dataModelAnn.annotationType().getAnnotation(DataSelectorClass.class).value().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void outjectDataModelList(String name, Object list, DataBinder wrapper, Annotation dataModelAnn) {
        boolean dirty;
        ScopeType scope = wrapper.getVariableScope(dataModelAnn);
        Context context = this.getDataModelContext(scope);
        Object existingDataModel = context.get(name);
        boolean bl = dirty = existingDataModel == null || scope == ScopeType.PAGE || wrapper.isDirty(dataModelAnn, existingDataModel, list);
        if (dirty) {
            if (list != null) {
                context.set(name, wrapper.wrap(dataModelAnn, list));
            } else {
                context.remove(name);
            }
        }
    }

    private Context getDataModelContext(ScopeType specifiedScope) {
        ScopeType scope = this.scope;
        if (scope == ScopeType.STATELESS) {
            scope = ScopeType.EVENT;
        }
        if (specifiedScope != ScopeType.UNSPECIFIED) {
            scope = specifiedScope;
        }
        return scope.getContext();
    }

    private void injectMethods(Object bean) {
        for (Method method : this.getInMethods()) {
            In in = method.getAnnotation(In.class);
            String name = Component.toName(in.value(), method);
            this.setPropertyValue(bean, method, name, this.getInstanceToInject(in, name, bean));
        }
    }

    private void injectFields(Object bean) {
        for (Field field : this.getInFields()) {
            In in = field.getAnnotation(In.class);
            String name = Component.toName(in.value(), field);
            this.setFieldValue(bean, field, name, this.getInstanceToInject(in, name, bean));
        }
    }

    private void outjectFields(Object bean) {
        for (Field field : this.getOutFields()) {
            Out out = field.getAnnotation(Out.class);
            if (out == null) continue;
            String name = Component.toName(out.value(), field);
            this.setOutjectedValue(out, name, this.getFieldValue(bean, field, name));
        }
    }

    private void outjectMethods(Object bean) {
        for (Method method : this.getOutMethods()) {
            Out out = method.getAnnotation(Out.class);
            if (out == null) continue;
            String name = Component.toName(out.value(), method);
            this.setOutjectedValue(out, name, this.getPropertyValue(bean, method, name));
        }
    }

    private void setOutjectedValue(Out out, String name, Object value) {
        ScopeType scope;
        if (value == null && out.required()) {
            throw new RequiredException("Out attribute requires value for component: " + this.getAttributeMessage(name));
        }
        if (out.scope() == ScopeType.UNSPECIFIED) {
            Component component = Component.forName(name);
            if (value != null && component != null && !component.isInstance(value)) {
                throw new IllegalArgumentException("attempted to bind an Out attribute of the wrong type to: " + this.getAttributeMessage(name));
            }
            scope = component == null ? ScopeType.EVENT : component.getScope();
        } else {
            scope = out.scope();
        }
        if (value == null) {
            scope.getContext().remove(name);
        } else {
            scope.getContext().set(name, value);
        }
    }

    public boolean isInstance(Object bean) {
        switch (this.type) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return this.beanClass.isInstance(bean);
            }
        }
        Class<?> clazz = bean.getClass();
        for (Class intfc : this.businessInterfaces) {
            if (!intfc.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private static Set<Class> getBusinessInterfaces(Class clazz) {
        HashSet<Class> result = new HashSet<Class>();
        if (clazz.isAnnotationPresent(Local.class)) {
            Local local = clazz.getAnnotation(Local.class);
            for (Class iface : local.value()) {
                result.add(iface);
            }
        }
        if (clazz.isAnnotationPresent(Remote.class)) {
            Remote remote = clazz.getAnnotation(Remote.class);
            for (Class iface : remote.value()) {
                result.add(iface);
            }
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!iface.isAnnotationPresent(Local.class) && !iface.isAnnotationPresent(Remote.class)) continue;
            result.add(iface);
        }
        if (result.size() == 0) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (Component.isExcludedLocalInterfaceName(iface.getName())) continue;
                result.add(iface);
            }
        }
        return result;
    }

    public Set<Class> getBusinessInterfaces() {
        return this.businessInterfaces;
    }

    private static boolean isExcludedLocalInterfaceName(String name) {
        return name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || name.startsWith("javax.ejb.");
    }

    private Object getFieldValue(Object bean, Field field, String name) {
        try {
            return field.get(bean);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not get field value: " + this.getAttributeMessage(name), e);
        }
    }

    private Object getPropertyValue(Object bean, Method method, String name) {
        try {
            return Reflections.invoke(method, bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not get property value: " + this.getAttributeMessage(name), e);
        }
    }

    private void setPropertyValue(Object bean, Method method, String name, Object value) {
        try {
            Reflections.invoke(method, bean, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not set property value: " + this.getAttributeMessage(name), e);
        }
    }

    private void setFieldValue(Object bean, Field field, String name, Object value) {
        try {
            field.set(bean, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not set field value: " + this.getAttributeMessage(name), e);
        }
    }

    public static Component forName(String name) {
        return (Component)Contexts.getApplicationContext().get(name + ".component");
    }

    public static Object getInstance(Class<?> clazz) {
        return Component.getInstance(clazz, true);
    }

    public static Object getInstance(Class<?> clazz, boolean create) {
        return Component.getInstance(Seam.getComponentName(clazz), create);
    }

    public static Object getInstance(Class<?> clazz, ScopeType scope, boolean create) {
        return Component.getInstance(Seam.getComponentName(clazz), scope, create);
    }

    public static Object getInstance(String name) {
        return Component.getInstance(name, true);
    }

    public static Object getInstance(String name, boolean create) {
        Object result = Contexts.lookupInStatefulContexts(name);
        result = Component.getInstance(name, create, result);
        return result;
    }

    public static Object getInstance(String name, ScopeType scope, boolean create) {
        Object result = scope.getContext().get(name);
        result = Component.getInstance(name, create, result);
        return result;
    }

    private static Object getInstance(String name, boolean create, Object result) {
        if (result == null && create && (result = Component.getInstanceFromFactory(name)) == null) {
            result = Component.newInstance(name);
        }
        if (result != null) {
            Component component = Component.forName(name);
            if (component != null && !component.isInstance(result)) {
                throw new IllegalArgumentException("value found for In attribute has the wrong type: " + name);
            }
            result = Component.unwrap(component, result);
        }
        return result;
    }

    public static Object getInstanceFromFactory(String name) {
        Init.FactoryMethod factoryMethod;
        Init init = Init.instance();
        Init.FactoryMethod factoryMethod2 = factoryMethod = init == null ? null : init.getFactory(name);
        if (factoryMethod == null) {
            return null;
        }
        Object factory = Component.getInstance(factoryMethod.component.getName(), true);
        Component.callComponentMethod(factoryMethod.component, factory, factoryMethod.method);
        return Contexts.lookupInStatefulContexts(name);
    }

    public static Object newInstance(String name) {
        Component component = Component.forName(name);
        if (component == null) {
            log.debug((Object)("seam component not found: " + name));
            return null;
        }
        Object instance = component.newInstance();
        if (component.getScope() != ScopeType.STATELESS) {
            component.getScope().getContext().set(name, instance);
            Component.callCreateMethod(component, instance);
        }
        return instance;
    }

    private static void callCreateMethod(Component component, Object instance) {
        if (component.hasCreateMethod()) {
            Component.callComponentMethod(component, instance, component.getCreateMethod());
        }
    }

    public static Object callComponentMethod(Component component, Object instance, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        String createMethodName = method.getName();
        try {
            Method interfaceMethod = instance.getClass().getMethod(createMethodName, paramTypes);
            if (paramTypes.length == 0) {
                return Reflections.invokeAndWrap(interfaceMethod, instance, new Object[0]);
            }
            return Reflections.invokeAndWrap(interfaceMethod, instance, component);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("create method not found", e);
        }
    }

    private static Object unwrap(Component component, Object instance) {
        if (component != null && component.hasUnwrapMethod()) {
            instance = Component.callComponentMethod(component, instance, component.getUnwrapMethod());
        }
        return instance;
    }

    private Object getInstanceToInject(In in, String name, Object bean) {
        Object result;
        if (name.startsWith("#")) {
            FacesContext facesCtx = FacesContext.getCurrentInstance();
            Application application = facesCtx.getApplication();
            result = application.createValueBinding(name).getValue(facesCtx);
        } else if (in.scope() == ScopeType.UNSPECIFIED) {
            result = Component.getInstance(name, in.create());
        } else {
            if (in.create()) {
                throw new IllegalArgumentException("cannot combine create=true with explicit scope on @In: " + this.getAttributeMessage(name));
            }
            result = in.scope().getContext().get(name);
        }
        if (result == null && in.required()) {
            throw new RequiredException("In attribute requires value for component: " + this.getAttributeMessage(name));
        }
        return result;
    }

    private String getAttributeMessage(String attributeName) {
        return this.getName() + '.' + attributeName;
    }

    private static String toName(String name, Method method) {
        if (name == null || name.length() == 0) {
            name = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        }
        return name;
    }

    private static String toName(String name, Field field) {
        if (name == null || name.length() == 0) {
            name = field.getName();
        }
        return name;
    }

    public String toString() {
        return "Component(" + this.name + ")";
    }

    private Class<net.sf.cglib.proxy.Factory> createProxyFactory() {
        Enhancer en = new Enhancer();
        en.setUseCache(false);
        en.setInterceptDuringConstruction(false);
        en.setCallbackType(MethodInterceptor.class);
        en.setSuperclass(this.beanClass);
        return en.createClass();
    }

    public InterceptionType getInterceptionType() {
        return this.interceptionType;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public String[] getDependencies() {
        return this.dependencies;
    }

    public boolean isMutable() {
        return this.mutable;
    }
}

