/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.ProcessInstance;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessProcessContext
implements Context {
    private static final Log log = LogFactory.getLog(BusinessProcessContext.class);
    private final Map<String, Object> additions = new HashMap<String, Object>();
    private final Set<String> removals = new HashSet<String>();

    @Override
    public ScopeType getType() {
        return ScopeType.BUSINESS_PROCESS;
    }

    @Override
    public Object get(String name) {
        Object result = this.additions.get(name);
        if (result != null) {
            return result;
        }
        if (this.removals.contains(name)) {
            return null;
        }
        TaskInstance taskInstance = this.getTaskInstance();
        if (taskInstance == null) {
            ContextInstance context = this.getContextInstance();
            return context == null ? null : context.getVariable(name);
        }
        return taskInstance.getVariable(name);
    }

    @Override
    public void set(String name, Object value) {
        if (value == null) {
            this.remove(name);
        } else {
            this.removals.remove(name);
            this.additions.put(name, value);
        }
    }

    @Override
    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    @Override
    public void remove(String name) {
        this.additions.remove(name);
        this.removals.add(name);
    }

    @Override
    public String[] getNames() {
        Set<String> results = this.getNamesFromContext();
        results.addAll(this.additions.keySet());
        return results.toArray(new String[0]);
    }

    private Set<String> getNamesFromContext() {
        HashSet<String> results = new HashSet<String>();
        TaskInstance taskInstance = this.getTaskInstance();
        if (taskInstance == null) {
            ContextInstance context = this.getContextInstance();
            if (context != null) {
                results.addAll(context.getVariables().keySet());
            }
        } else {
            results.addAll(taskInstance.getVariables().keySet());
        }
        results.removeAll(this.removals);
        return results;
    }

    @Override
    public Object get(Class clazz) {
        return this.get(Seam.getComponentName(clazz));
    }

    public void clear() {
        this.additions.clear();
        this.removals.addAll(this.getNamesFromContext());
    }

    @Override
    public void flush() {
        if (!this.additions.isEmpty() || !this.removals.isEmpty()) {
            TaskInstance taskInstance = this.getTaskInstance();
            if (taskInstance == null) {
                org.jbpm.graph.exe.ProcessInstance processInstance = this.getProcessInstance();
                if (processInstance == null) {
                    log.debug((Object)"no process instance to persist business process state");
                } else {
                    this.flushToProcessInstance(processInstance);
                }
            } else {
                this.flushToTaskInstance(taskInstance);
            }
            this.additions.clear();
            this.removals.clear();
        }
    }

    private void flushToTaskInstance(TaskInstance taskInstance) {
        log.debug((Object)("flushing to task instance: " + taskInstance.getId()));
        for (Map.Entry<String, Object> entry : this.additions.entrySet()) {
            taskInstance.setVariableLocally(entry.getKey(), entry.getValue());
        }
        for (String name : this.removals) {
            taskInstance.deleteVariableLocally(name);
        }
    }

    private void flushToProcessInstance(org.jbpm.graph.exe.ProcessInstance processInstance) {
        log.debug((Object)("flushing to process instance: " + processInstance.getId()));
        ContextInstance contextInstance = processInstance.getContextInstance();
        for (Map.Entry<String, Object> entry : this.additions.entrySet()) {
            contextInstance.setVariable(entry.getKey(), entry.getValue());
        }
        for (String name : this.removals) {
            contextInstance.deleteVariable(name);
        }
    }

    private ContextInstance getContextInstance() {
        org.jbpm.graph.exe.ProcessInstance processInstance = this.getProcessInstance();
        return processInstance == null ? null : processInstance.getContextInstance();
    }

    private org.jbpm.graph.exe.ProcessInstance getProcessInstance() {
        Init init = Init.instance();
        if (init == null || !init.isJbpmInstalled()) {
            return null;
        }
        return ProcessInstance.instance();
    }

    private TaskInstance getTaskInstance() {
        Init init = Init.instance();
        if (init == null || !init.isJbpmInstalled()) {
            return null;
        }
        return org.jboss.seam.core.TaskInstance.instance();
    }
}

