/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.StatelessContext;
import org.jboss.seam.util.Reflections;

public class Contexts {
    private static final Log log = LogFactory.getLog(Contexts.class);
    static final ThreadLocal<Context> applicationContext = new ThreadLocal();
    static final ThreadLocal<Context> eventContext = new ThreadLocal();
    static final ThreadLocal<Context> pageContext = new ThreadLocal();
    static final ThreadLocal<Context> sessionContext = new ThreadLocal();
    static final ThreadLocal<Context> conversationContext = new ThreadLocal();
    static final ThreadLocal<Context> businessProcessContext = new ThreadLocal();

    public static Context getEventContext() {
        return eventContext.get();
    }

    public static Context getPageContext() {
        return pageContext.get();
    }

    public static Context getSessionContext() {
        return sessionContext.get();
    }

    public static Context getApplicationContext() {
        return applicationContext.get();
    }

    public static Context getStatelessContext() {
        return new StatelessContext();
    }

    public static Context getConversationContext() {
        return conversationContext.get();
    }

    public static Context getBusinessProcessContext() {
        return businessProcessContext.get();
    }

    public static boolean isConversationContextActive() {
        return Contexts.getConversationContext() != null;
    }

    public static boolean isEventContextActive() {
        return eventContext.get() != null;
    }

    public static boolean isPageContextActive() {
        return pageContext.get() != null;
    }

    public static boolean isSessionContextActive() {
        return sessionContext.get() != null;
    }

    public static boolean isApplicationContextActive() {
        return applicationContext.get() != null;
    }

    public static boolean isBusinessProcessContextActive() {
        return businessProcessContext.get() != null;
    }

    public static void removeFromAllContexts(String name) {
        log.debug((Object)("removing from all contexts: " + name));
        if (Contexts.isEventContextActive()) {
            Contexts.getEventContext().remove(name);
        }
        if (Contexts.isConversationContextActive()) {
            Contexts.getConversationContext().remove(name);
        }
        if (Contexts.isSessionContextActive()) {
            Contexts.getSessionContext().remove(name);
        }
        if (Contexts.isBusinessProcessContextActive()) {
            Contexts.getBusinessProcessContext().remove(name);
        }
        if (Contexts.isApplicationContextActive()) {
            Contexts.getApplicationContext().remove(name);
        }
    }

    public static Object lookupInStatefulContexts(String name) {
        Object result;
        if (Contexts.isEventContextActive() && (result = Contexts.getEventContext().get(name)) != null) {
            log.debug((Object)("found in event context: " + name));
            return result;
        }
        if (Contexts.isPageContextActive() && (result = Contexts.getPageContext().get(name)) != null) {
            log.debug((Object)("found in page context: " + name));
            return result;
        }
        if (Contexts.isConversationContextActive() && (result = Contexts.getConversationContext().get(name)) != null) {
            log.debug((Object)("found in conversation context: " + name));
            return result;
        }
        if (Contexts.isSessionContextActive() && (result = Contexts.getSessionContext().get(name)) != null) {
            log.debug((Object)("found in session context: " + name));
            return result;
        }
        if (Contexts.isBusinessProcessContextActive() && (result = Contexts.getBusinessProcessContext().get(name)) != null) {
            log.debug((Object)("found in business process context: " + name));
            return result;
        }
        if (Contexts.isApplicationContextActive() && (result = Contexts.getApplicationContext().get(name)) != null) {
            log.debug((Object)("found in application context: " + name));
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(Context context) {
        Lifecycle.startDestroying();
        try {
            for (String name : context.getNames()) {
                Component component = Component.forName(name);
                log.debug((Object)("destroying: " + name));
                if (component == null) continue;
                try {
                    Contexts.callDestroyMethod(component, context.get(name));
                }
                catch (Exception e) {
                    log.warn((Object)("Could not destroy component: " + name), (Throwable)e);
                }
            }
        }
        finally {
            Lifecycle.stopDestroying();
        }
    }

    private static void callDestroyMethod(Component component, Object instance) {
        if (component.hasDestroyMethod()) {
            String methodName = component.getDestroyMethod().getName();
            try {
                Method method = instance.getClass().getMethod(methodName, new Class[0]);
                Reflections.invokeAndWrap(method, instance, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                log.warn((Object)"could not find destroy method", (Throwable)e);
            }
        }
    }
}

