/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Lifecycle;

public class PageContext
implements Context {
    private Map<String, Object> previousPageMap = (Map)this.getAttributeMap().remove(ScopeType.PAGE.getPrefix());
    private Map<String, Object> nextPageMap;

    public PageContext() {
        if (this.previousPageMap == null) {
            this.previousPageMap = new HashMap<String, Object>();
        }
        this.nextPageMap = new HashMap<String, Object>();
    }

    public ScopeType getType() {
        return ScopeType.CONVERSATION;
    }

    public Object get(String name) {
        return this.getCurrentReadableMap().get(name);
    }

    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    private Map getCurrentReadableMap() {
        return Lifecycle.getPhaseId().compareTo((Object)PhaseId.INVOKE_APPLICATION) > 0 ? this.nextPageMap : this.previousPageMap;
    }

    private Map getCurrentWritableMap() {
        return Lifecycle.getPhaseId().compareTo((Object)PhaseId.INVOKE_APPLICATION) < 0 ? this.previousPageMap : this.nextPageMap;
    }

    public void set(String name, Object value) {
        this.getCurrentWritableMap().put(name, value);
    }

    public void remove(String name) {
        this.getCurrentWritableMap().remove(name);
    }

    public String[] getNames() {
        return this.previousPageMap.keySet().toArray(new String[0]);
    }

    public String toString() {
        return "PageContext";
    }

    public Object get(Class clazz) {
        return this.get(Seam.getComponentName(clazz));
    }

    public void flush() {
        this.getAttributeMap().put(ScopeType.PAGE.getPrefix(), this.nextPageMap);
    }

    private Map getAttributeMap() {
        return FacesContext.getCurrentInstance().getViewRoot().getAttributes();
    }
}

