/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.Manager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversationEntry
implements Serializable,
Comparable<ConversationEntry> {
    private long lastRequestTime;
    private String description;
    private String id;
    private Date startDatetime;
    private Date lastDatetime;
    private String viewId;
    private LinkedList<String> conversationIdStack;
    private String initiatorComponentName;
    private Integer timeout;
    private boolean removeAfterRedirect;

    public ConversationEntry(String id, LinkedList<String> stack) {
        this.id = id;
        this.conversationIdStack = stack;
        this.startDatetime = new Date();
    }

    public ConversationEntry(String id) {
        this.id = id;
        this.conversationIdStack = new LinkedList();
        this.conversationIdStack.add(id);
        this.startDatetime = new Date();
    }

    public String getDescription() {
        String desc;
        if (this.isCurrent() && (desc = Conversation.instance().description) != null) {
            return desc;
        }
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    void touch() {
        this.lastRequestTime = System.currentTimeMillis();
        this.lastDatetime = new Date();
    }

    public String getId() {
        return this.id;
    }

    public Date getStartDatetime() {
        return this.startDatetime;
    }

    public String destroy() {
        boolean success = Manager.instance().swapConversation(this.getId());
        if (success) {
            Manager.instance().endConversation();
        }
        return null;
    }

    public String select() {
        boolean success = Manager.instance().swapConversation(this.getId());
        if (success) {
            Manager.instance().redirect(this.getViewId());
            return "org.jboss.seam.switch";
        }
        return null;
    }

    void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public String getViewId() {
        String out;
        if (this.isCurrent() && (out = Conversation.instance().viewId) != null) {
            return out;
        }
        return this.viewId;
    }

    public Date getLastDatetime() {
        return this.lastDatetime;
    }

    public LinkedList<String> getConversationIdStack() {
        return this.conversationIdStack;
    }

    public String getInitiatorComponentName() {
        return this.initiatorComponentName;
    }

    void setInitiatorComponentName(String ownerComponentName) {
        this.initiatorComponentName = ownerComponentName;
    }

    public boolean isDisplayable() {
        Manager manager = Manager.instance();
        return this.getDescription() != null && (manager.isLongRunningConversation() || !this.id.equals(manager.getCurrentConversationId()));
    }

    public boolean isCurrent() {
        Manager manager = Manager.instance();
        if (manager.isLongRunningConversation()) {
            return this.id.equals(manager.getCurrentConversationId());
        }
        LinkedList<String> stack = manager.getCurrentConversationIdStack();
        return stack != null && stack.size() > 1 && ((String)stack.get(1)).equals(this.id);
    }

    @Override
    public int compareTo(ConversationEntry entry) {
        int result = new Long(this.getLastRequestTime()).compareTo(entry.getLastRequestTime());
        return -(result == 0 ? this.getId().compareTo(entry.getId()) : result);
    }

    public int getTimeout() {
        return this.timeout == null ? Manager.instance().getConversationTimeout() : this.timeout.intValue();
    }

    void setTimeout(int conversationTimeout) {
        this.timeout = conversationTimeout;
    }

    public boolean isRemoveAfterRedirect() {
        return this.removeAfterRedirect;
    }

    public void setRemoveAfterRedirect(boolean removeAfterRedirect) {
        this.removeAfterRedirect = removeAfterRedirect;
    }

    void setId(String id) {
        this.id = id;
    }
}

