/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="conversationStack")
@Intercept(value=InterceptionType.NEVER)
public class ConversationStack
implements Serializable {
    private List<ConversationEntry> conversationEntryStack;

    @Create
    public void createConversationEntryStack() {
        Manager manager = Manager.instance();
        Map<String, ConversationEntry> map = manager.getConversationIdEntryMap();
        ConversationEntry currentConversationEntry = manager.getCurrentConversationEntry();
        if (currentConversationEntry != null) {
            LinkedList<String> idStack = currentConversationEntry.getConversationIdStack();
            this.conversationEntryStack = new ArrayList<ConversationEntry>(map.size());
            ListIterator<String> ids = idStack.listIterator(idStack.size());
            while (ids.hasPrevious()) {
                ConversationEntry entry = map.get(ids.previous());
                if (!entry.isDisplayable() || Seam.isSessionInvalid()) continue;
                this.conversationEntryStack.add(entry);
            }
        }
    }

    @Unwrap
    public List<ConversationEntry> getConversationEntryStack() {
        return this.conversationEntryStack;
    }
}

