/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.init")
public class Init {
    private static final Log log = LogFactory.getLog(Init.class);
    private boolean isClientSideConversations = false;
    private boolean jbpmInstalled;
    private String jndiPattern;
    private boolean debug;
    private boolean myFacesLifecycleBug;
    private List<String> mutableComponentNames = new ArrayList<String>();
    private Map<String, FactoryMethod> factories = new HashMap<String, FactoryMethod>();
    private Map<String, List<ObserverMethod>> observers = new HashMap<String, List<ObserverMethod>>();

    public static Init instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        Init init = (Init)Contexts.getApplicationContext().get(Init.class);
        return init;
    }

    public boolean isClientSideConversations() {
        return this.isClientSideConversations;
    }

    public void setClientSideConversations(boolean isClientSideConversations) {
        this.isClientSideConversations = isClientSideConversations;
    }

    public FactoryMethod getFactory(String variable) {
        return this.factories.get(variable);
    }

    public void addFactoryMethod(String variable, Method method, Component component) {
        this.factories.put(variable, new FactoryMethod(method, component));
    }

    public List<ObserverMethod> getObservers(String eventType) {
        return this.observers.get(eventType);
    }

    public void addObserverMethod(String eventType, Method method, Component component) {
        List<ObserverMethod> observerList = this.observers.get(eventType);
        if (observerList == null) {
            observerList = new ArrayList<ObserverMethod>();
            this.observers.put(eventType, observerList);
        }
        observerList.add(new ObserverMethod(method, component));
    }

    public boolean isJbpmInstalled() {
        return this.jbpmInstalled;
    }

    public String getJndiPattern() {
        return this.jndiPattern;
    }

    public void setJndiPattern(String jndiPattern) {
        this.jndiPattern = jndiPattern;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isMyFacesLifecycleBug() {
        return this.myFacesLifecycleBug;
    }

    public void setMyFacesLifecycleBug(boolean myFacesLifecycleBugExists) {
        this.myFacesLifecycleBug = myFacesLifecycleBugExists;
    }

    public void setJbpmInstalled(boolean jbpmInstalled) {
        this.jbpmInstalled = jbpmInstalled;
    }

    public List<String> getMutableComponentNames() {
        return this.mutableComponentNames;
    }

    public static class ObserverMethod {
        public Method method;
        public Component component;

        ObserverMethod(Method method, Component component) {
            this.method = method;
            this.component = component;
        }
    }

    public static class FactoryMethod {
        public Method method;
        public Component component;

        FactoryMethod(Method method, Component component) {
            this.method = method;
            this.component = component;
        }
    }
}

