/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;

@Intercept(value=InterceptionType.NEVER)
@Scope(value=ScopeType.STATELESS)
@Name(value="interpolator")
public class Interpolator {
    private static final Log log = LogFactory.getLog(Interpolator.class);

    public static Interpolator instance() {
        if (Contexts.isApplicationContextActive()) {
            return (Interpolator)Component.getInstance(Interpolator.class, true);
        }
        return new Interpolator();
    }

    public String interpolate(String string, Object ... params) {
        if (string.indexOf(35) < 0) {
            return string;
        }
        if (params.length > 10) {
            throw new IllegalArgumentException("more than 10 parameters");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        StringTokenizer tokens = new StringTokenizer(string, "#{}", true);
        StringBuilder builder = new StringBuilder(string.length());
        while (tokens.hasMoreTokens()) {
            String tok = tokens.nextToken();
            if ("#".equals(tok)) {
                String nextTok = tokens.nextToken();
                if ("{".equals(nextTok)) {
                    String expression = "#{" + tokens.nextToken() + "}";
                    try {
                        Object value = context.getApplication().createValueBinding(expression).getValue(context);
                        if (value != null) {
                            builder.append(value);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("exception interpolating string: " + string), (Throwable)e);
                    }
                    tokens.nextToken();
                    continue;
                }
                int index = Integer.parseInt(nextTok.substring(0, 1));
                if (index >= params.length) {
                    throw new IllegalArgumentException("parameter index out of bounds: " + index + " in: " + string);
                }
                builder.append(params[index]);
                builder.append(nextTok.substring(1));
                continue;
            }
            builder.append(tok);
        }
        return builder.toString();
    }
}

