/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Mutable;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Messages;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.SESSION)
@Name(value="localeSelector")
@Intercept(value=InterceptionType.NEVER)
@Mutable
public class LocaleSelector
implements Serializable {
    private String language;
    private String country;
    private String variant;

    public void select() {
        FacesContext.getCurrentInstance().getViewRoot().setLocale(this.getLocale());
        Contexts.removeFromAllContexts(Seam.getComponentName(ResourceBundle.class));
        Contexts.removeFromAllContexts(Seam.getComponentName(Messages.class));
    }

    public Locale calculateLocale(Locale jsfLocale) {
        if (!Strings.isEmpty(this.variant)) {
            return new Locale(this.language, this.country, this.variant);
        }
        if (!Strings.isEmpty(this.country)) {
            return new Locale(this.language, this.country);
        }
        if (!Strings.isEmpty(this.language)) {
            return new Locale(this.language);
        }
        return jsfLocale;
    }

    public void setLocale(Locale locale) {
        this.language = Strings.nullIfEmpty(locale.getLanguage());
        this.country = Strings.nullIfEmpty(locale.getCountry());
        this.variant = Strings.nullIfEmpty(locale.getVariant());
    }

    public String getLocaleString() {
        return this.getLocale().toString();
    }

    public void setLocaleString(String localeString) {
        StringTokenizer tokens = new StringTokenizer(localeString, "-_");
        this.language = tokens.hasMoreTokens() ? tokens.nextToken() : null;
        this.country = tokens.hasMoreTokens() ? tokens.nextToken() : null;
        this.variant = tokens.hasMoreTokens() ? tokens.nextToken() : null;
    }

    public List<SelectItem> getSupportedLocales() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        Iterator locales = FacesContext.getCurrentInstance().getApplication().getSupportedLocales();
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            if (Strings.isEmpty(locale.getLanguage())) continue;
            selectItems.add(new SelectItem((Object)locale.toString(), locale.getDisplayName(locale)));
        }
        return selectItems;
    }

    public Locale getLocale() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return this.calculateLocale(Locale.getDefault());
        }
        return facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
    }

    public static LocaleSelector instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        return (LocaleSelector)Component.getInstance(Seam.getComponentName(LocaleSelector.class), ScopeType.SESSION, true);
    }

    public String getCountry() {
        if (this.country == null) {
            return this.getLocale().getCountry();
        }
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLanguage() {
        if (this.language == null) {
            return this.getLocale().getLanguage();
        }
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getVariant() {
        if (this.variant == null) {
            return this.getLocale().getVariant();
        }
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }
}

