/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Mutable;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.CONVERSATION)
@Intercept(value=InterceptionType.NEVER)
@Mutable
public class ManagedHibernateSession
implements Serializable {
    private static final long serialVersionUID = 3130309555079841107L;
    private static final Log log = LogFactory.getLog(ManagedHibernateSession.class);
    private Session session;
    private String sessionFactoryJndiName;
    private String componentName;

    @Create
    public void create(Component component) {
        this.componentName = component.getName();
        if (this.sessionFactoryJndiName == null) {
            this.sessionFactoryJndiName = "java:/" + this.componentName;
        }
        try {
            this.session = this.getSessionFactory().openSession();
        }
        catch (NamingException ne) {
            throw new IllegalArgumentException("SessionFactory not found", ne);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created seam managed session for session factory: " + this.sessionFactoryJndiName));
        }
    }

    @Unwrap
    public Session getSession() {
        this.session.isOpen();
        return this.session;
    }

    @Destroy
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroying seam managed session for session factory: " + this.sessionFactoryJndiName));
        }
        this.session.close();
    }

    private SessionFactory getSessionFactory() throws NamingException {
        return (SessionFactory)Naming.getInitialContext().lookup(this.sessionFactoryJndiName);
    }

    public String getSessionFactoryJndiName() {
        return this.sessionFactoryJndiName;
    }

    public void setSessionFactoryJndiName(String sessionFactoryName) {
        this.sessionFactoryJndiName = sessionFactoryName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String toString() {
        return "ManagedHibernateSession(" + this.sessionFactoryJndiName + ")";
    }
}

