/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Jbpm;
import org.jboss.seam.core.ProcessInstance;
import org.jboss.seam.util.Transactions;
import org.jbpm.JbpmContext;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;

@Scope(value=ScopeType.EVENT)
@Name(value="jbpmContext")
@Intercept(value=InterceptionType.NEVER)
public class ManagedJbpmContext
implements Synchronization {
    private static final Log log = LogFactory.getLog(ManagedJbpmContext.class);
    private JbpmContext jbpmContext;
    private boolean synchronizationRegistered;

    @Create
    public void create() throws NamingException, RollbackException, SystemException {
        this.jbpmContext = Jbpm.instance().getJbpmConfiguration().createJbpmContext();
        this.assertNoTransactionManagement();
        log.debug((Object)"created seam managed jBPM context");
    }

    private void assertNoTransactionManagement() {
        DbPersistenceServiceFactory dpsf = (DbPersistenceServiceFactory)this.jbpmContext.getJbpmConfiguration().getServiceFactory("persistence");
        if (dpsf.isTransactionEnabled()) {
            throw new IllegalStateException("jBPM transaction management is enabled, disable in jbpm.cfg.xml");
        }
    }

    @Unwrap
    public JbpmContext getJbpmContext() throws NamingException, RollbackException, SystemException {
        if (!Transactions.isTransactionActiveOrMarkedRollback()) {
            throw new IllegalStateException("JbpmContext may only be used inside a transaction");
        }
        if (!this.synchronizationRegistered && Transactions.isTransactionActive()) {
            Transactions.registerSynchronization(this);
            this.synchronizationRegistered = true;
        }
        return this.jbpmContext;
    }

    public void beforeCompletion() {
        log.debug((Object)"flushing seam managed jBPM context");
        org.jbpm.graph.exe.ProcessInstance processInstance = ProcessInstance.instance();
        if (processInstance != null) {
            this.jbpmContext.save(processInstance);
        }
        Contexts.getBusinessProcessContext().flush();
        this.jbpmContext.getSession().flush();
    }

    public void afterCompletion(int status) {
        this.synchronizationRegistered = false;
    }

    @Destroy
    public void destroy() {
        log.debug((Object)"destroying seam managed jBPM context");
        this.jbpmContext.getSession().clear();
        this.jbpmContext.close();
    }

    public static JbpmContext instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("no active event context");
        }
        return (JbpmContext)Component.getInstance(ManagedJbpmContext.class, ScopeType.EVENT, true);
    }
}

