/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Mutable;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Transactions;

@Scope(value=ScopeType.CONVERSATION)
@Intercept(value=InterceptionType.NEVER)
@Mutable
public class ManagedPersistenceContext
implements Serializable {
    private static final Log log = LogFactory.getLog(ManagedPersistenceContext.class);
    private EntityManager entityManager;
    private String persistenceUnitJndiName;
    private String componentName;

    @Create
    public void create(Component component) {
        this.componentName = component.getName();
        if (this.persistenceUnitJndiName == null) {
            this.persistenceUnitJndiName = "java:/" + this.componentName;
        }
        try {
            this.entityManager = this.getEntityManagerFactory().createEntityManager();
        }
        catch (NamingException ne) {
            throw new IllegalArgumentException("EntityManagerFactory not found", ne);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created seam managed persistence context for persistence unit: " + this.persistenceUnitJndiName));
        }
    }

    @Unwrap
    public EntityManager getEntityManager() throws NamingException, SystemException {
        if (Transactions.isTransactionActive()) {
            this.entityManager.joinTransaction();
        }
        return this.entityManager;
    }

    @Destroy
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroying seam managed persistence context for persistence unit: " + this.persistenceUnitJndiName));
        }
        this.entityManager.close();
    }

    private EntityManagerFactory getEntityManagerFactory() throws NamingException {
        return (EntityManagerFactory)Naming.getInitialContext().lookup(this.persistenceUnitJndiName);
    }

    public String getPersistenceUnitJndiName() {
        return this.persistenceUnitJndiName;
    }

    public void setPersistenceUnitJndiName(String persistenceUnitName) {
        this.persistenceUnitJndiName = persistenceUnitName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String toString() {
        return "ManagedPersistenceContext(" + this.persistenceUnitJndiName + ")";
    }
}

