/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.ResourceBundle;

@Scope(value=ScopeType.SESSION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="messages")
public class Messages
implements Serializable {
    private transient Map<String, String> messages;

    private void init() {
        this.messages = new AbstractMap<String, String>(){
            private java.util.ResourceBundle bundle = ResourceBundle.instance();
            private Map<String, String> cache = new HashMap<String, String>();

            @Override
            public String get(Object key) {
                if (key instanceof String) {
                    String resourceKey = (String)key;
                    String cachedValue = this.cache.get(key);
                    if (cachedValue == null) {
                        String resource;
                        try {
                            resource = this.bundle.getString(resourceKey);
                        }
                        catch (MissingResourceException mre) {
                            return resourceKey;
                        }
                        if (resource == null) {
                            return resourceKey;
                        }
                        this.cache.put(resourceKey, resource);
                        return Interpolator.instance().interpolate(resource, new Object[0]);
                    }
                    return Interpolator.instance().interpolate(cachedValue, new Object[0]);
                }
                return null;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                Enumeration<String> keys = this.bundle.getKeys();
                HashMap<String, String> map = new HashMap<String, String>();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    map.put(key, this.get(key));
                }
                return map.entrySet();
            }
        };
    }

    @Unwrap
    public Map getMessages() {
        if (this.messages == null) {
            this.init();
        }
        return this.messages;
    }

    public static Map instance() {
        return (Map)Component.getInstance(Seam.getComponentName(Messages.class), true);
    }
}

