/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.core.Locale;

@Scope(value=ScopeType.SESSION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="resourceBundle")
public class ResourceBundle
implements Serializable {
    private static final Log log = LogFactory.getLog(ResourceBundle.class);
    private String bundleName = "messages";
    private transient java.util.ResourceBundle bundle;

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    private void loadBundle() {
        try {
            this.bundle = java.util.ResourceBundle.getBundle(this.bundleName, Locale.instance(), Thread.currentThread().getContextClassLoader());
            log.debug((Object)("loaded resource bundle: " + this.bundleName));
        }
        catch (MissingResourceException mre) {
            log.debug((Object)("resource bundle missing: " + this.bundleName));
        }
    }

    @Unwrap
    public java.util.ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.loadBundle();
        }
        return this.bundle;
    }

    public static java.util.ResourceBundle instance() {
        return (java.util.ResourceBundle)Component.getInstance(Seam.getComponentName(ResourceBundle.class), true);
    }
}

