/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.debug;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.RequestParameter;
import org.jboss.seam.contexts.Contexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.debug.introspector")
public class Introspector {
    @RequestParameter
    private String name;

    public Attribute[] getAttributes() throws Exception {
        if (this.name == null) {
            return null;
        }
        Object component = Contexts.lookupInStatefulContexts(this.name);
        if (component == null) {
            return null;
        }
        if (component instanceof Map) {
            return this.getMapAttributes((Map)component);
        }
        if (component instanceof List) {
            return this.getListAttributes((List)component);
        }
        return this.getComponentAttributes(component);
    }

    public Attribute[] getMapAttributes(Map<Object, Object> map) {
        Attribute[] attributes = new Attribute[map.size()];
        int i = 0;
        for (Map.Entry<Object, Object> me : map.entrySet()) {
            attributes[i++] = new Attribute(me.getKey().toString(), me.getValue());
        }
        return attributes;
    }

    public Attribute[] getListAttributes(List list) {
        Attribute[] attributes = new Attribute[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            attributes[i] = new Attribute(Integer.toString(i), list.get(i));
        }
        return attributes;
    }

    private Attribute[] getComponentAttributes(Object component) throws IntrospectionException, IllegalAccessException {
        String toString;
        BeanInfo bi = java.beans.Introspector.getBeanInfo(component.getClass());
        PropertyDescriptor[] properties = bi.getPropertyDescriptors();
        Attribute[] attributes = new Attribute[properties.length + 1];
        for (int i = 0; i < properties.length; ++i) {
            boolean convertArrayToList;
            List<Object> value;
            try {
                Method readMethod = properties[i].getReadMethod();
                if (readMethod == null) continue;
                value = readMethod.invoke(component, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getCause();
                value = e.getClass().getName() + '[' + e.getMessage() + ']';
            }
            boolean bl = convertArrayToList = value != null && value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive();
            if (convertArrayToList) {
                value = Arrays.asList((Object[])value);
            }
            attributes[i] = new Attribute(properties[i].getDisplayName(), value);
        }
        try {
            toString = component.toString();
        }
        catch (Exception e) {
            toString = e.getClass().getName() + '[' + e.getMessage() + ']';
        }
        attributes[properties.length] = new Attribute("toString()", toString);
        return attributes;
    }

    public static class Attribute {
        private String name;
        private Object value;

        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

