/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    private static final Log log = LogFactory.getLog(Scanner.class);
    private String resourceName;
    private ClassLoader classLoader;

    public Scanner() {
        this("seam.properties", Thread.currentThread().getContextClassLoader());
    }

    public Scanner(String resourceName, ClassLoader classLoader) {
        this.resourceName = resourceName;
        this.classLoader = classLoader;
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    public Set<Class<?>> getClasses() {
        Enumeration<URL> urls;
        HashSet result = new HashSet();
        try {
            urls = this.classLoader.getResources(this.resourceName);
        }
        catch (IOException ioe) {
            log.warn((Object)("could not read: " + this.resourceName), (Throwable)ioe);
            return result;
        }
        while (urls.hasMoreElements()) {
            try {
                String urlPath = urls.nextElement().getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                urlPath = urlPath.indexOf(33) > 0 ? urlPath.substring(0, urlPath.indexOf(33)) : new File(urlPath).getParent();
                log.info((Object)("scanning: " + urlPath));
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.handleDirectory(result, file, null);
                    continue;
                }
                this.handleArchive(result, file);
            }
            catch (IOException ioe) {
                log.warn((Object)"could not read entries", (Throwable)ioe);
            }
        }
        return result;
    }

    private void handleArchive(Set<Class<?>> result, File file) throws ZipException, IOException {
        log.debug((Object)("archive: " + file));
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            log.debug((Object)("found: " + name));
            this.handleItem(result, name);
        }
    }

    private void handleDirectory(Set<Class<?>> result, File file, String path) {
        log.debug((Object)("directory: " + file));
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(result, child, newPath);
                continue;
            }
            this.handleItem(result, newPath);
        }
    }

    private void handleItem(Set<Class<?>> result, String name) {
        if (name.endsWith(".class") && !name.startsWith("org/jboss/seam/core")) {
            String classname = Scanner.filenameToClassname(name);
            try {
                result.add(this.classLoader.loadClass(classname));
            }
            catch (ClassNotFoundException cnfe) {
                log.debug((Object)("could not load class: " + classname), (Throwable)cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                log.debug((Object)("could not load class (missing dependency): " + classname), (Throwable)ncdfe);
            }
        }
    }
}

