/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.drools;

import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.PackageDescr;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.util.Resources;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
public class RuleBase {
    private String[] ruleFiles;
    private org.drools.RuleBase ruleBase;

    @Create
    public void compileRuleBase() throws Exception {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        conf.setCompiler(1);
        PackageBuilder builder = new PackageBuilder(conf);
        for (String ruleFile : this.ruleFiles) {
            InputStreamReader reader = new InputStreamReader(Resources.getResourceAsStream(ruleFile));
            PackageDescr packageDescr = new DrlParser().parse((Reader)reader);
            builder.addPackage(packageDescr);
        }
        this.ruleBase = RuleBaseFactory.newRuleBase();
        this.ruleBase.addPackage(builder.getPackage());
    }

    @Unwrap
    public org.drools.RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public String[] getRuleFiles() {
        return this.ruleFiles;
    }

    public void setRuleFiles(String[] ruleFiles) {
        this.ruleFiles = ruleFiles;
    }
}

