/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Roles;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Actor;
import org.jboss.seam.core.ApplicationContext;
import org.jboss.seam.core.BusinessProcessContext;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationContext;
import org.jboss.seam.core.ConversationList;
import org.jboss.seam.core.ConversationStack;
import org.jboss.seam.core.EventContext;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.FacesContext;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.HttpError;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.IsUserInRole;
import org.jboss.seam.core.Jbpm;
import org.jboss.seam.core.Locale;
import org.jboss.seam.core.LocaleSelector;
import org.jboss.seam.core.ManagedJbpmContext;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Messages;
import org.jboss.seam.core.PageContext;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Pages;
import org.jboss.seam.core.PojoCache;
import org.jboss.seam.core.PooledTask;
import org.jboss.seam.core.PooledTaskInstanceList;
import org.jboss.seam.core.Process;
import org.jboss.seam.core.ProcessInstance;
import org.jboss.seam.core.Redirect;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.core.SessionContext;
import org.jboss.seam.core.StatelessContext;
import org.jboss.seam.core.Switcher;
import org.jboss.seam.core.TaskInstance;
import org.jboss.seam.core.TaskInstanceList;
import org.jboss.seam.core.TaskInstanceListForType;
import org.jboss.seam.core.Transition;
import org.jboss.seam.core.UiComponent;
import org.jboss.seam.core.UserPrincipal;
import org.jboss.seam.debug.Introspector;
import org.jboss.seam.deployment.Scanner;
import org.jboss.seam.jms.ManagedQueueSender;
import org.jboss.seam.jms.ManagedTopicPublisher;
import org.jboss.seam.jms.QueueConnection;
import org.jboss.seam.jms.QueueSession;
import org.jboss.seam.jms.TopicConnection;
import org.jboss.seam.jms.TopicSession;
import org.jboss.seam.remoting.messaging.SubscriptionRegistry;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Transactions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Initialization {
    private static final Log log = LogFactory.getLog(Initialization.class);
    private Map<String, String> properties = new HashMap<String, String>();
    private ServletContext servletContext;
    private boolean isScannerEnabled = true;
    private Map<String, Class> components = new HashMap<String, Class>();

    public Initialization(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.initPropertiesFromXml();
        this.initPropertiesFromServletContext();
        this.initPropertiesFromResource();
    }

    private void initPropertiesFromXml() {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/components.xml", this.servletContext);
        if (stream == null) {
            log.info((Object)"no components.xml file found");
        } else {
            log.info((Object)"reading components.xml");
            try {
                Properties replacements = new Properties();
                InputStream replaceStream = Resources.getResourceAsStream("components.properties");
                if (replaceStream != null) {
                    replacements.load(replaceStream);
                }
                SAXReader saxReader = new SAXReader();
                saxReader.setMergeAdjacentText(true);
                Document doc = saxReader.read(stream);
                List elements = doc.getRootElement().elements("component");
                for (Element component : elements) {
                    String installed = component.attributeValue("installed");
                    if (installed != null && !"true".equals(this.replace(installed, replacements))) continue;
                    this.installComponent(component, replacements);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading components.xml", e);
            }
        }
    }

    private String replace(String value, Properties replacements) {
        if (value.startsWith("@")) {
            value = replacements.getProperty(value.substring(1, value.length() - 1));
        }
        return value;
    }

    private void installComponent(Element component, Properties replacements) throws ClassNotFoundException {
        String name = component.attributeValue("name");
        String className = component.attributeValue("class");
        if (className != null) {
            Class clazz = Reflections.classForName(className);
            if (name == null) {
                name = clazz.getAnnotation(Name.class).value();
            }
            this.components.put(name, clazz);
        } else if (name == null) {
            throw new IllegalArgumentException("must specify either class or name in components.xml");
        }
        List props = component.elements("property");
        for (Element prop : props) {
            String propName = name + '.' + prop.attributeValue("name");
            String value = prop.getTextTrim();
            this.properties.put(propName, this.replace(value, replacements));
        }
    }

    public Initialization setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public Initialization init() {
        log.info((Object)"initializing Seam");
        Lifecycle.beginInitialization(this.servletContext);
        Contexts.getApplicationContext().set("org.jboss.seam.properties", this.properties);
        this.addComponents();
        Lifecycle.endInitialization();
        log.info((Object)"done initializing Seam");
        return this;
    }

    private void initPropertiesFromServletContext() {
        Enumeration params = this.servletContext.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            this.properties.put(name, this.servletContext.getInitParameter(name));
        }
    }

    private void initPropertiesFromResource() {
        this.loadFromResource(this.properties, "/seam.properties");
        Properties jndiProperties = new Properties();
        this.loadFromResource(jndiProperties, "/jndi.properties");
        this.loadFromResource(jndiProperties, "/seam-jndi.properties");
        Naming.setInitialContextProperties(jndiProperties);
    }

    private static void initUserTransactionName(Properties properties) {
        String userTransactionName = properties.getProperty("jta.UserTransaction");
        if (userTransactionName != null) {
            Transactions.setUserTransactionName(userTransactionName);
        }
    }

    public void loadFromResource(Map properties, String resource) {
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            log.info((Object)("reading properties from: " + resource));
            Properties props = new Properties();
            try {
                props.load(stream);
            }
            catch (IOException ioe) {
                log.error((Object)("could not read " + resource), (Throwable)ioe);
            }
            properties.putAll(props);
            Initialization.initUserTransactionName(props);
        } else {
            log.debug((Object)("not found: " + resource));
        }
    }

    protected void addComponents() {
        Context context = Contexts.getApplicationContext();
        this.addComponent(Init.class, context);
        Init init = (Init)Component.getInstance(Init.class, ScopeType.APPLICATION, true);
        this.addComponent(Pages.class, context);
        this.addComponent(Events.class, context);
        this.addComponent(Manager.class, context);
        this.addComponent(Switcher.class, context);
        this.addComponent(Redirect.class, context);
        this.addComponent(HttpError.class, context);
        this.addComponent(UserPrincipal.class, context);
        this.addComponent(IsUserInRole.class, context);
        this.addComponent(Conversation.class, context);
        this.addComponent(ConversationList.class, context);
        this.addComponent(ConversationStack.class, context);
        this.addComponent(FacesContext.class, context);
        this.addComponent(PageContext.class, context);
        this.addComponent(EventContext.class, context);
        this.addComponent(SessionContext.class, context);
        this.addComponent(StatelessContext.class, context);
        this.addComponent(ApplicationContext.class, context);
        this.addComponent(ConversationContext.class, context);
        this.addComponent(BusinessProcessContext.class, context);
        this.addComponent(Locale.class, context);
        this.addComponent(Messages.class, context);
        this.addComponent(Interpolator.class, context);
        this.addComponent(FacesMessages.class, context);
        this.addComponent(ResourceBundle.class, context);
        this.addComponent(LocaleSelector.class, context);
        this.addComponent(UiComponent.class, context);
        this.addComponent(SubscriptionRegistry.class, context);
        try {
            this.addComponent(PojoCache.class, context);
        }
        catch (NoClassDefFoundError ncdfe) {
            // empty catch block
        }
        if (this.components.values().contains(Jbpm.class)) {
            init.setJbpmInstalled(true);
        }
        if (init.isDebug()) {
            this.addComponent(Introspector.class, context);
            this.addComponent(org.jboss.seam.debug.Contexts.class, context);
        }
        if (init.isJbpmInstalled()) {
            this.addComponent(Actor.class, context);
            this.addComponent(Process.class, context);
            this.addComponent(Pageflow.class, context);
            this.addComponent(Transition.class, context);
            this.addComponent(PooledTask.class, context);
            this.addComponent(TaskInstance.class, context);
            this.addComponent(ProcessInstance.class, context);
            this.addComponent(TaskInstanceList.class, context);
            this.addComponent(PooledTaskInstanceList.class, context);
            this.addComponent(TaskInstanceListForType.class, context);
            this.addComponent(ManagedJbpmContext.class, context);
        }
        if (this.components.values().contains(ManagedTopicPublisher.class)) {
            this.addComponent(TopicConnection.class, context);
            this.addComponent(TopicSession.class, context);
        }
        if (this.components.values().contains(ManagedQueueSender.class)) {
            this.addComponent(QueueConnection.class, context);
            this.addComponent(QueueSession.class, context);
        }
        for (Map.Entry<String, Class> entry : this.components.entrySet()) {
            this.addComponent(entry.getKey(), entry.getValue(), context);
        }
        if (this.isScannerEnabled) {
            for (Class clazz : new Scanner().getClasses()) {
                if (!clazz.isAnnotationPresent(Name.class)) continue;
                this.addComponent(clazz, context);
                this.addComponentRoles(context, clazz);
            }
        }
    }

    private void addComponentRoles(Context context, Class<Object> componentClass) {
        if (componentClass.isAnnotationPresent(Role.class)) {
            Role role = componentClass.getAnnotation(Role.class);
            ScopeType scope = Seam.getComponentRoleScope(componentClass, role);
            this.addComponent(role.name(), scope, componentClass, context);
        }
        if (componentClass.isAnnotationPresent(Roles.class)) {
            Role[] roles;
            for (Role role : roles = componentClass.getAnnotation(Roles.class).value()) {
                ScopeType scope = Seam.getComponentRoleScope(componentClass, role);
                this.addComponent(role.name(), scope, componentClass, context);
            }
        }
    }

    protected void addComponent(String name, ScopeType scope, Class clazz, Context context) {
        context.set(name + ".component", new Component(clazz, name, scope));
    }

    protected void addComponent(String name, Class clazz, Context context) {
        context.set(name + ".component", new Component(clazz, name));
    }

    protected void addComponent(Class clazz, Context context) {
        context.set(Seam.getComponentName(clazz) + ".component", new Component(clazz));
    }

    public boolean isScannerEnabled() {
        return this.isScannerEnabled;
    }

    public Initialization setScannerEnabled(boolean isScannerEnabled) {
        this.isScannerEnabled = isScannerEnabled;
        return this;
    }
}

