/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.Around;
import org.jboss.seam.annotations.BeginTask;
import org.jboss.seam.annotations.CreateProcess;
import org.jboss.seam.annotations.EndTask;
import org.jboss.seam.annotations.ResumeProcess;
import org.jboss.seam.annotations.StartTask;
import org.jboss.seam.annotations.Transition;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Actor;
import org.jboss.seam.core.ManagedJbpmContext;
import org.jboss.seam.core.Process;
import org.jboss.seam.core.TaskInstance;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;

@Around(value={ValidationInterceptor.class, BijectionInterceptor.class, OutcomeInterceptor.class})
public class BusinessProcessInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(BusinessProcessInterceptor.class);

    @AroundInvoke
    public Object manageBusinessProcessContext(InvocationContext invocation) throws Exception {
        Method method = invocation.getMethod();
        log.trace((Object)("Starting bpm interception [component=" + this.component.getName() + ", method=" + method.getName() + "]"));
        this.beforeInvocation(invocation);
        return this.afterInvocation(invocation, invocation.proceed());
    }

    private void beforeInvocation(InvocationContext invocationContext) {
        Method method = invocationContext.getMethod();
        if (method.isAnnotationPresent(StartTask.class)) {
            log.trace((Object)"encountered @StartTask");
            StartTask tag = method.getAnnotation(StartTask.class);
            this.initTask(tag.taskIdParameter());
        } else if (method.isAnnotationPresent(BeginTask.class)) {
            log.trace((Object)"encountered @BeginTask");
            BeginTask tag = method.getAnnotation(BeginTask.class);
            this.initTask(tag.taskIdParameter());
        } else if (method.isAnnotationPresent(ResumeProcess.class)) {
            log.trace((Object)"encountered @ResumeProcess");
            ResumeProcess tag = method.getAnnotation(ResumeProcess.class);
            this.initProcess(tag.processIdParameter());
        }
    }

    private void initProcess(String processIdParameter) {
        Process.instance().setProcessId(this.getRequestParamValueAsLong(processIdParameter));
    }

    private void initTask(String taskIdParameter) {
        Process context = Process.instance();
        context.setTaskId(this.getRequestParamValueAsLong(taskIdParameter));
        org.jbpm.taskmgmt.exe.TaskInstance taskInstance = TaskInstance.instance();
        context.setProcessId(taskInstance.getTaskMgmtInstance().getProcessInstance().getId());
    }

    private Object afterInvocation(InvocationContext invocation, Object result) {
        Method method = invocation.getMethod();
        if (result != null || method.getReturnType().equals(Void.TYPE)) {
            if (method.isAnnotationPresent(CreateProcess.class)) {
                log.trace((Object)"encountered @CreateProcess");
                CreateProcess tag = method.getAnnotation(CreateProcess.class);
                this.createProcess(tag.definition());
            }
            if (method.isAnnotationPresent(StartTask.class)) {
                log.trace((Object)"encountered @StartTask");
                this.startTask();
            }
            if (method.isAnnotationPresent(EndTask.class)) {
                log.trace((Object)"encountered @EndTask");
                this.endTask(method.getAnnotation(EndTask.class).transition());
            }
            if (method.isAnnotationPresent(Transition.class)) {
                log.trace((Object)"encountered @Transition");
                String name = method.getAnnotation(Transition.class).value();
                org.jboss.seam.core.ProcessInstance.instance().signal(name);
            }
        }
        return result;
    }

    private void createProcess(String processDefinitionName) {
        JbpmContext jbpmContext = ManagedJbpmContext.instance();
        ProcessDefinition pd = jbpmContext.getGraphSession().findLatestProcessDefinition(processDefinitionName);
        if (pd == null) {
            throw new IllegalArgumentException("Unknown process definition: " + processDefinitionName);
        }
        ProcessInstance process = pd.createProcessInstance();
        jbpmContext.save(process);
        Process.instance().setProcessId(process.getId());
        Contexts.getBusinessProcessContext().flush();
        process.signal();
    }

    private void startTask() {
        String actorId = Actor.instance().getId();
        org.jbpm.taskmgmt.exe.TaskInstance task = TaskInstance.instance();
        if (actorId != null) {
            task.start(actorId);
        } else {
            task.start();
        }
    }

    private void endTask(String transitionName) {
        org.jbpm.taskmgmt.exe.TaskInstance task = TaskInstance.instance();
        if (task == null) {
            throw new IllegalStateException("no task instance associated with context");
        }
        if ("".equals(transitionName)) {
            transitionName = org.jboss.seam.core.Transition.instance().getName();
        }
        if (transitionName == null) {
            task.end();
        } else {
            task.end(transitionName);
        }
        Process.instance().setTaskId(null);
    }

    private Long getRequestParamValueAsLong(String paramName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String paramValue = (String)paramMap.get(paramName);
        PropertyEditor editor = PropertyEditorManager.findEditor(Long.class);
        if (editor != null) {
            editor.setAsText(paramValue);
            return (Long)editor.getValue();
        }
        return Long.parseLong(paramValue);
    }
}

