/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import java.util.Arrays;
import javax.faces.application.FacesMessage;
import javax.faces.event.PhaseId;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.Around;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.BeginTask;
import org.jboss.seam.annotations.Conversational;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.EndTask;
import org.jboss.seam.annotations.StartTask;
import org.jboss.seam.annotations.Within;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.BusinessProcessInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;

@Around(value={ValidationInterceptor.class, BijectionInterceptor.class, OutcomeInterceptor.class})
@Within(value={BusinessProcessInterceptor.class})
public class ConversationInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(ConversationInterceptor.class);

    @AroundInvoke
    public Object endOrBeginLongRunningConversation(InvocationContext invocation) throws Exception {
        Method method = invocation.getMethod();
        if (this.isNoConversationForConversationalBean(method)) {
            log.info((Object)("no long-running conversation for @Conversational bean: " + this.component.getName()));
            FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.NoConversation", "No conversation", new Object[0]);
            if (method.getReturnType().equals(String.class)) {
                return this.methodIsConversational(method) ? method.getAnnotation(Conversational.class).ifNotBegunOutcome() : this.component.getBeanClass().getAnnotation(Conversational.class).ifNotBegunOutcome();
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                return null;
            }
        }
        if (this.isMissingJoin(method)) {
            throw new IllegalStateException("begin method invoked from a long running conversation, try using @Begin(join=true)");
        }
        String outcome = this.getOutcomeForConversationId(method);
        if (outcome != null) {
            if (!method.getReturnType().equals(String.class)) {
                throw new IllegalStateException("begin method return type was not a string");
            }
            return outcome;
        }
        Object result = invocation.proceed();
        this.beginConversationIfNecessary(method, result);
        this.endConversationIfNecessary(method, result);
        return result;
    }

    public String getOutcomeForConversationId(Method method) {
        String id = null;
        if (method.isAnnotationPresent(Begin.class)) {
            id = method.getAnnotation(Begin.class).id();
        } else if (method.isAnnotationPresent(BeginTask.class)) {
            id = method.getAnnotation(BeginTask.class).id();
        } else if (method.isAnnotationPresent(StartTask.class)) {
            id = method.getAnnotation(StartTask.class).id();
        }
        if (id != null && !"".equals(id)) {
            id = Interpolator.instance().interpolate(id, new Object[0]);
            ConversationEntry ce = Manager.instance().getConversationIdEntryMap().get(id);
            if (ce == null) {
                Manager.instance().updateCurrentConversationId(id);
            } else {
                return ce.select();
            }
        }
        return null;
    }

    private boolean isMissingJoin(Method method) {
        return Manager.instance().isLongRunningConversation() && (method.isAnnotationPresent(Begin.class) && !method.getAnnotation(Begin.class).join() && !method.getAnnotation(Begin.class).nested() || method.isAnnotationPresent(BeginTask.class) || method.isAnnotationPresent(StartTask.class));
    }

    private boolean isNoConversationForConversationalBean(Method method) {
        boolean classlevelViolation;
        boolean bl = classlevelViolation = this.componentIsConversational() && Lifecycle.getPhaseId() == PhaseId.INVOKE_APPLICATION && (!Manager.instance().isLongRunningConversation() || this.componentShouldBeInitiator() && !this.componentIsInitiator()) && !method.isAnnotationPresent(Begin.class) && !method.isAnnotationPresent(StartTask.class) && !method.isAnnotationPresent(BeginTask.class) && !method.isAnnotationPresent(Destroy.class) && !method.isAnnotationPresent(Create.class);
        if (classlevelViolation) {
            return true;
        }
        boolean methodlevelViolation = this.methodIsConversational(method) && Lifecycle.getPhaseId() == PhaseId.INVOKE_APPLICATION && (!Manager.instance().isLongRunningConversation() || this.componentShouldBeInitiator(method) && !this.componentIsInitiator());
        return methodlevelViolation;
    }

    private boolean methodIsConversational(Method method) {
        return method.isAnnotationPresent(Conversational.class);
    }

    private boolean componentShouldBeInitiator(Method method) {
        return method.getAnnotation(Conversational.class).initiator();
    }

    private boolean componentIsConversational() {
        return this.component.getBeanClass().isAnnotationPresent(Conversational.class);
    }

    private boolean componentShouldBeInitiator() {
        return this.component.getBeanClass().getAnnotation(Conversational.class).initiator();
    }

    private boolean componentIsInitiator() {
        return this.component.getName().equals(Manager.instance().getCurrentConversationInitiator());
    }

    private void beginConversationIfNecessary(Method method, Object result) {
        String[] outcomes;
        boolean simpleBegin;
        boolean bl = simpleBegin = method.isAnnotationPresent(StartTask.class) || method.isAnnotationPresent(BeginTask.class) || method.isAnnotationPresent(Begin.class) && method.getAnnotation(Begin.class).ifOutcome().length == 0;
        if (simpleBegin) {
            if (result != null || method.getReturnType().equals(Void.TYPE)) {
                boolean nested = false;
                if (method.isAnnotationPresent(Begin.class)) {
                    nested = method.getAnnotation(Begin.class).nested();
                }
                this.beginConversation(nested, this.getProcessDefinitionName(method));
            }
        } else if (method.isAnnotationPresent(Begin.class) && ((outcomes = method.getAnnotation(Begin.class).ifOutcome()).length == 0 || Arrays.asList(outcomes).contains(result))) {
            this.beginConversation(method.getAnnotation(Begin.class).nested(), this.getProcessDefinitionName(method));
        }
    }

    private String getProcessDefinitionName(Method method) {
        if (method.isAnnotationPresent(Begin.class)) {
            return method.getAnnotation(Begin.class).pageflow();
        }
        if (method.isAnnotationPresent(BeginTask.class)) {
            return method.getAnnotation(BeginTask.class).pageflow();
        }
        if (method.isAnnotationPresent(StartTask.class)) {
            return method.getAnnotation(StartTask.class).pageflow();
        }
        return "";
    }

    private void beginConversation(boolean nested, String processDefinitionName) {
        if (!Manager.instance().isLongRunningConversation()) {
            log.debug((Object)"Beginning long-running conversation");
            Manager.instance().beginConversation(this.component.getName());
            this.beginNavigation(processDefinitionName);
        } else if (nested) {
            log.debug((Object)"Beginning nested conversation");
            Manager.instance().beginNestedConversation(this.component.getName());
            this.beginNavigation(processDefinitionName);
        }
    }

    private void beginNavigation(String processDefinitionName) {
        if (!processDefinitionName.equals("")) {
            Pageflow.instance().begin(processDefinitionName);
        }
    }

    private void endConversationIfNecessary(Method method, Object result) {
        String[] outcomes;
        boolean simpleEnd;
        boolean bl = simpleEnd = method.isAnnotationPresent(End.class) && method.getAnnotation(End.class).ifOutcome().length == 0 || method.isAnnotationPresent(EndTask.class) && method.getAnnotation(EndTask.class).ifOutcome().length == 0;
        if (simpleEnd) {
            if (result != null || method.getReturnType().equals(Void.TYPE)) {
                this.endConversation();
            }
        } else if (method.isAnnotationPresent(End.class)) {
            String[] outcomes2 = method.getAnnotation(End.class).ifOutcome();
            if (Arrays.asList(outcomes2).contains(result)) {
                this.endConversation();
            }
        } else if (method.isAnnotationPresent(EndTask.class) && Arrays.asList(outcomes = method.getAnnotation(EndTask.class).ifOutcome()).contains(result)) {
            this.endConversation();
        }
    }

    private void endConversation() {
        log.debug((Object)"Ending long-running conversation");
        Manager.instance().endConversation();
    }
}

