/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jbpm;

import org.dom4j.Element;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Process;
import org.jboss.seam.core.Transition;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class Page
extends Node
implements Parsable {
    private static final long serialVersionUID = 1L;
    private String viewId;
    private boolean isConversationEnd = false;
    private String transition;
    private boolean redirect;
    private String description;
    private Integer timeout;
    private boolean backEnabled;

    public void read(Element pageElement, JpdlXmlReader jpdlXmlReader) {
        String timeoutString;
        Element descriptionElement;
        this.viewId = pageElement.attributeValue("view-id");
        this.backEnabled = "enabled".equals(pageElement.attributeValue("back"));
        Element conversationEndElement = pageElement.element("end-conversation");
        if (conversationEndElement != null) {
            this.isConversationEnd = true;
            this.transition = conversationEndElement.attributeValue("transition");
        }
        this.redirect = "true".equals(pageElement.attributeValue("redirect"));
        if (pageElement.element("redirect") != null) {
            this.redirect = true;
        }
        if ((descriptionElement = pageElement.element("description")) != null) {
            this.description = descriptionElement.getTextTrim();
        }
        if ((timeoutString = pageElement.attributeValue("timeout")) != null) {
            this.timeout = Integer.parseInt(timeoutString);
        }
    }

    public void execute(ExecutionContext executionContext) {
        if (this.isConversationEnd) {
            TaskInstance task = org.jboss.seam.core.TaskInstance.instance();
            if (task != null) {
                if (this.transition == null || "".equals(this.transition)) {
                    this.transition = Transition.instance().getName();
                }
                if (this.transition == null) {
                    task.end();
                } else {
                    task.end(this.transition);
                }
                Process.instance().setTaskId(null);
            }
            Manager.instance().endConversation();
        }
    }

    public boolean isConversationEnd() {
        return this.isConversationEnd;
    }

    public String getTransition() {
        return this.transition;
    }

    public String getViewId() {
        return this.viewId;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return Interpolator.instance().interpolate(this.description, new Object[0]);
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public boolean isBackEnabled() {
        return this.backEnabled;
    }
}

