/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Pages;

public abstract class AbstractSeamPhaseListener
implements PhaseListener {
    private static final Log log = LogFactory.getLog(AbstractSeamPhaseListener.class);
    private static boolean exists = false;

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public static void restoreAnyConversationContext(FacesContext facesContext) {
        Lifecycle.resumePage();
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        Manager.instance().restoreConversation(parameters);
        Lifecycle.resumeConversation(facesContext.getExternalContext());
        if (Init.instance().isJbpmInstalled()) {
            Pageflow.instance().validatePageflow();
        }
        Manager.instance().handleConversationPropagation(parameters);
        AbstractSeamPhaseListener.selectDataModelRow(parameters);
        if (log.isDebugEnabled()) {
            log.debug((Object)("After restoring conversation context: " + Contexts.getConversationContext()));
        }
    }

    public static void storeAnyConversationContext(FacesContext facesContext) {
        if (!Contexts.isConversationContextActive()) {
            log.debug((Object)"No active conversation context");
        } else {
            Lifecycle.flushClientConversation();
            ContextAdaptor session = ContextAdaptor.getSession(facesContext.getExternalContext(), true);
            Manager.instance().storeConversation(session, facesContext.getExternalContext().getResponse());
        }
        Lifecycle.flushPage();
    }

    private static void selectDataModelRow(Map parameters) {
        String dataModelSelection = (String)parameters.get("dataModelSelection");
        if (dataModelSelection != null) {
            int loc = dataModelSelection.indexOf(91);
            String name = dataModelSelection.substring(0, loc);
            int index = Integer.parseInt(dataModelSelection.substring(loc + 1, dataModelSelection.length() - 1));
            Object value = Contexts.lookupInStatefulContexts(name);
            if (value != null) {
                ((DataModel)value).setRowIndex(index);
            }
        }
    }

    protected void beforeRender(PhaseEvent event) {
        this.callPageActions(event);
        FacesContext facesContext = event.getFacesContext();
        if (facesContext.getResponseComplete()) {
            AbstractSeamPhaseListener.storeAnyConversationContext(facesContext);
            if (Init.instance().isMyFacesLifecycleBug()) {
                Lifecycle.endRequest(facesContext.getExternalContext());
            }
        } else {
            FacesMessages.instance().beforeRenderResponse();
            Manager.instance().prepareBackswitch(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean callPageActions(PhaseEvent event) {
        Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
        boolean actionsWereCalled = false;
        try {
            actionsWereCalled = Pages.callAction(event.getFacesContext()) || actionsWereCalled;
            boolean bl = actionsWereCalled = Pages.instance().callAction() || actionsWereCalled;
            return bl;
        }
        finally {
            Lifecycle.setPhaseId(PhaseId.RENDER_RESPONSE);
            if (actionsWereCalled) {
                FacesMessages.afterPhase();
                this.afterPageActions();
            }
        }
    }

    protected void afterPageActions() {
    }

    protected AbstractSeamPhaseListener() {
        if (exists) {
            log.warn((Object)"There should only be one Seam phase listener per application");
        }
        exists = true;
    }
}

