/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.core.Init;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.util.Transactions;

public class SeamExtendedManagedPersistencePhaseListener
extends SeamPhaseListener {
    private static final Log log = LogFactory.getLog(SeamExtendedManagedPersistencePhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        boolean beginTran;
        PhaseId phaseId = event.getPhaseId();
        boolean bl = beginTran = phaseId == PhaseId.RESTORE_VIEW || phaseId == PhaseId.RENDER_RESPONSE && !Init.instance().isClientSideConversations();
        if (beginTran) {
            this.begin(phaseId);
        }
        super.beforePhase(event);
    }

    public void afterPhase(PhaseEvent event) {
        boolean commitTran;
        PhaseId phaseId = event.getPhaseId();
        boolean bl = commitTran = phaseId == PhaseId.INVOKE_APPLICATION || event.getFacesContext().getRenderResponse() || event.getFacesContext().getResponseComplete() || phaseId == PhaseId.RENDER_RESPONSE && !Init.instance().isClientSideConversations();
        if (commitTran) {
            this.commitOrRollback(phaseId);
        }
        super.afterPhase(event);
    }

    protected void afterPageActions() {
        this.commitOrRollback(PhaseId.INVOKE_APPLICATION);
        this.begin(PhaseId.INVOKE_APPLICATION);
    }

    private void begin(PhaseId phaseId) {
        try {
            if (!Transactions.isTransactionActiveOrMarkedRollback()) {
                log.debug((Object)("beginning transaction prior to phase: " + phaseId));
                Transactions.getUserTransaction().begin();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start transaction", e);
        }
    }

    private void commitOrRollback(PhaseId phaseId) {
        try {
            if (Transactions.isTransactionActive()) {
                log.debug((Object)("committing transaction after phase: " + phaseId));
                Transactions.getUserTransaction().commit();
            } else if (Transactions.isTransactionMarkedRollback()) {
                log.debug((Object)("rolling back transaction after phase: " + phaseId));
                Transactions.getUserTransaction().rollback();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }
}

