/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.jsf.SeamPortletPhaseListener;
import org.jboss.seam.util.Transactions;

public class SeamExtendedManagedPersistencePortletPhaseListener
extends SeamPortletPhaseListener {
    private static final Log log = LogFactory.getLog(SeamExtendedManagedPersistencePortletPhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        boolean beginTran;
        PhaseId phaseId = event.getPhaseId();
        boolean bl = beginTran = phaseId == PhaseId.RESTORE_VIEW || phaseId == PhaseId.RENDER_RESPONSE || phaseId == PhaseId.INVOKE_APPLICATION;
        if (beginTran) {
            this.begin(phaseId);
        }
        super.beforePhase(event);
    }

    public void afterPhase(PhaseEvent event) {
        boolean commitTran;
        PhaseId phaseId = event.getPhaseId();
        boolean bl = commitTran = phaseId == PhaseId.INVOKE_APPLICATION || event.getFacesContext().getRenderResponse() || phaseId == PhaseId.RENDER_RESPONSE;
        if (commitTran) {
            this.commit(phaseId);
        }
        super.afterPhase(event);
    }

    protected void afterPageActions() {
        this.commit(PhaseId.INVOKE_APPLICATION);
        this.begin(PhaseId.INVOKE_APPLICATION);
    }

    private void begin(PhaseId phaseId) {
        try {
            if (!Transactions.isTransactionActiveOrMarkedRollback()) {
                log.debug((Object)("beginning transaction prior to phase: " + phaseId));
                Transactions.getUserTransaction().begin();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start transaction", e);
        }
    }

    private void commit(PhaseId phaseId) {
        try {
            if (Transactions.isTransactionActive()) {
                log.debug((Object)("committing transaction after phase: " + phaseId));
                Transactions.getUserTransaction().commit();
            } else if (Transactions.isTransactionMarkedRollback()) {
                log.debug((Object)("rolling back transaction after phase: " + phaseId));
                Transactions.getUserTransaction().rollback();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }
}

