/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.jsf.AbstractSeamPhaseListener;
import org.jboss.seam.util.Transactions;

public class SeamPhaseListener
extends AbstractSeamPhaseListener {
    private static final Log log = LogFactory.getLog(SeamPhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        log.trace((Object)("before phase: " + event.getPhaseId()));
        Lifecycle.setPhaseId(event.getPhaseId());
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            Lifecycle.beginRequest(event.getFacesContext().getExternalContext());
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.beforeRender(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        log.trace((Object)("after phase: " + event.getPhaseId()));
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            SeamPhaseListener.restoreAnyConversationContext(facesContext);
        } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
            try {
                if (Transactions.isTransactionAvailableAndMarkedRollback()) {
                    FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.TransactionFailed", "Transaction failed", new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FacesMessages.afterPhase();
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            if (!Init.instance().isClientSideConversations()) {
                Manager.instance().conversationTimeout(facesContext.getExternalContext());
            }
            Lifecycle.endRequest(facesContext.getExternalContext());
        } else if (event.getPhaseId() != PhaseId.RESTORE_VIEW && facesContext.getResponseComplete()) {
            SeamPhaseListener.storeAnyConversationContext(facesContext);
            Lifecycle.endRequest(facesContext.getExternalContext());
        }
        Lifecycle.setPhaseId(null);
    }
}

