/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpSession;
import javax.transaction.UserTransaction;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Manager;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.jsf.SeamNavigationHandler;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.jsf.SeamStateManager;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.mock.MockHttpServletRequest;
import org.jboss.seam.mock.MockHttpSession;
import org.jboss.seam.mock.MockLifecycle;
import org.jboss.seam.mock.MockServletContext;
import org.jboss.seam.servlet.ServletSessionImpl;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Transactions;
import org.jboss.seam.util.Validation;
import org.testng.annotations.Configuration;

public class SeamTest {
    private MockExternalContext externalContext;
    private MockServletContext servletContext;
    private MockApplication application;
    private SeamPhaseListener phases;
    private MockFacesContext facesContext;
    private MockHttpSession session;
    private Map<String, ConversationState> conversationStates;

    protected HttpSession getSession() {
        return (HttpSession)this.externalContext.getSession(true);
    }

    protected boolean isSessionInvalid() {
        return ((MockHttpSession)this.getSession()).isInvalid();
    }

    protected FacesContext getFacesContext() {
        return this.facesContext;
    }

    @Configuration(beforeTestMethod=true)
    public void begin() {
        this.session = new MockHttpSession(this.servletContext);
    }

    @Configuration(afterTestMethod=true)
    public void end() {
        Lifecycle.endSession(this.servletContext, new ServletSessionImpl(this.session));
        this.session = null;
    }

    protected SeamPhaseListener createPhaseListener() {
        return new SeamPhaseListener();
    }

    @Configuration(beforeTestClass=true)
    public void init() throws Exception {
        this.application = new MockApplication();
        this.application.setStateManager(new SeamStateManager(this.application.getStateManager()));
        this.application.setNavigationHandler(new SeamNavigationHandler(this.application.getNavigationHandler()));
        this.phases = this.createPhaseListener();
        this.servletContext = new MockServletContext();
        this.initServletContext(this.servletContext.getInitParameters());
        new Initialization(this.servletContext).init();
        Lifecycle.setServletContext(this.servletContext);
        this.conversationStates = new HashMap<String, ConversationState>();
    }

    @Configuration(afterTestClass=true)
    public void cleanup() throws Exception {
        Lifecycle.endApplication(this.servletContext);
        this.externalContext = null;
        this.conversationStates.clear();
        this.conversationStates = null;
    }

    public void initServletContext(Map initParams) {
    }

    protected InitialContext getInitialContext() throws NamingException {
        return Naming.getInitialContext();
    }

    protected UserTransaction getUserTransaction() throws NamingException {
        return Transactions.getUserTransaction();
    }

    protected Object getField(Object object, String fieldName) {
        try {
            Field declaredField = object.getClass().getDeclaredField(fieldName);
            if (!declaredField.isAccessible()) {
                declaredField.setAccessible(true);
            }
            return declaredField.get(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not get field value: " + fieldName, e);
        }
    }

    protected void setField(Object object, String fieldName, Object value) {
        try {
            Field declaredField = object.getClass().getDeclaredField(fieldName);
            if (!declaredField.isAccessible()) {
                declaredField.setAccessible(true);
            }
            declaredField.set(object, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not set field value: " + fieldName, e);
        }
    }

    private class ConversationState {
        Map state = new HashMap();

        private ConversationState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Script {
        private String conversationId;
        private String outcome;
        private boolean validationFailed;

        protected Script() {
        }

        protected Script(String id) {
            this.conversationId = id;
        }

        protected boolean isGetRequest() {
            return false;
        }

        protected String getViewId() {
            return null;
        }

        protected Object getInstance(Class clazz) {
            return Component.getInstance(clazz, true);
        }

        protected Object getInstance(String name) {
            return Component.getInstance(name, true);
        }

        protected void applyRequestValues() throws Exception {
        }

        protected void processValidations() throws Exception {
        }

        protected void updateModelValues() throws Exception {
        }

        protected void invokeApplication() throws Exception {
        }

        protected void setOutcome(String outcome) {
            this.outcome = outcome;
        }

        protected String getInvokeApplicationOutcome() {
            return this.outcome;
        }

        protected void renderResponse() throws Exception {
        }

        protected void setup() {
        }

        public Map<String, String[]> getParameters() {
            return ((MockHttpServletRequest)SeamTest.this.externalContext.getRequest()).getParameters();
        }

        public Map<String, String[]> getHeaders() {
            return ((MockHttpServletRequest)SeamTest.this.externalContext.getRequest()).getHeaders();
        }

        protected void validate(Class modelClass, String property, Object value) {
            ClassValidator validator = Validation.getValidator(modelClass);
            InvalidValue[] ivs = validator.getPotentialInvalidValues(property, value);
            if (ivs.length > 0) {
                this.validationFailed = true;
                FacesMessage message = FacesMessages.createFacesMessage(FacesMessage.SEVERITY_WARN, ivs[0].getMessage(), new Object[0]);
                FacesContext.getCurrentInstance().addMessage(property, message);
                FacesContext.getCurrentInstance().renderResponse();
            }
        }

        public boolean isValidationFailure() {
            return this.validationFailed;
        }

        public String run() throws Exception {
            Map pageContextMap;
            SeamTest.this.externalContext = new MockExternalContext(SeamTest.this.servletContext, SeamTest.this.session);
            SeamTest.this.facesContext = new MockFacesContext(SeamTest.this.externalContext, SeamTest.this.application);
            SeamTest.this.facesContext.setCurrent();
            Map attributes = SeamTest.this.facesContext.getViewRoot().getAttributes();
            if (!this.isGetRequest() && this.conversationId != null && SeamTest.this.conversationStates.containsKey(this.conversationId)) {
                attributes.putAll(((ConversationState)((SeamTest)SeamTest.this).conversationStates.get((Object)this.conversationId)).state);
            }
            this.setup();
            SeamTest.this.facesContext.getViewRoot().setViewId(this.getViewId());
            SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.RESTORE_VIEW, MockLifecycle.INSTANCE));
            SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.RESTORE_VIEW, MockLifecycle.INSTANCE));
            if (!this.isGetRequest()) {
                SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.APPLY_REQUEST_VALUES, MockLifecycle.INSTANCE));
                this.applyRequestValues();
                SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.APPLY_REQUEST_VALUES, MockLifecycle.INSTANCE));
                SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.PROCESS_VALIDATIONS, MockLifecycle.INSTANCE));
                this.processValidations();
                SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.PROCESS_VALIDATIONS, MockLifecycle.INSTANCE));
                if (!FacesContext.getCurrentInstance().getRenderResponse()) {
                    SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.UPDATE_MODEL_VALUES, MockLifecycle.INSTANCE));
                    this.updateModelValues();
                    SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.UPDATE_MODEL_VALUES, MockLifecycle.INSTANCE));
                    SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.INVOKE_APPLICATION, MockLifecycle.INSTANCE));
                    this.invokeApplication();
                    String outcome = this.getInvokeApplicationOutcome();
                    SeamTest.this.facesContext.getApplication().getNavigationHandler().handleNavigation((FacesContext)SeamTest.this.facesContext, null, outcome);
                    SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.INVOKE_APPLICATION, MockLifecycle.INSTANCE));
                }
            }
            if (!FacesContext.getCurrentInstance().getResponseComplete()) {
                SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.RENDER_RESPONSE, MockLifecycle.INSTANCE));
                if (this.isGetRequest()) {
                    Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
                    this.invokeApplication();
                    Lifecycle.setPhaseId(PhaseId.RENDER_RESPONSE);
                }
                this.renderResponse();
                SeamTest.this.facesContext.getApplication().getStateManager().saveSerializedView((FacesContext)SeamTest.this.facesContext);
                SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)SeamTest.this.facesContext, PhaseId.RENDER_RESPONSE, MockLifecycle.INSTANCE));
            }
            if ((pageContextMap = (Map)attributes.get(ScopeType.PAGE.getPrefix())) != null) {
                this.conversationId = (String)pageContextMap.get(Manager.CONVERSATION_ID);
                ConversationState conversationState = new ConversationState();
                conversationState.state.putAll(attributes);
                SeamTest.this.conversationStates.put(this.conversationId, conversationState);
            }
            return this.conversationId;
        }
    }
}

