/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Manager;
import org.jboss.seam.remoting.BaseRequestHandler;
import org.jboss.seam.remoting.Call;
import org.jboss.seam.remoting.RequestContext;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.remoting.wrapper.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionHandler
extends BaseRequestHandler
implements RequestHandler {
    private static final Log log = LogFactory.getLog(ExecutionHandler.class);
    private static final byte[] HEADER_OPEN = "<header>".getBytes();
    private static final byte[] HEADER_CLOSE = "</header>".getBytes();
    private static final byte[] CONVERSATION_ID_TAG_OPEN = "<conversationId>".getBytes();
    private static final byte[] CONVERSATION_ID_TAG_CLOSE = "</conversationId>".getBytes();
    private static final byte[] CONTEXT_TAG_OPEN = "<context>".getBytes();
    private static final byte[] CONTEXT_TAG_CLOSE = "</context>".getBytes();
    private static final byte[] VALUE_TAG_OPEN = "<value>".getBytes();
    private static final byte[] VALUE_TAG_CLOSE = "</value>".getBytes();
    private static final byte[] RESULT_TAG_OPEN_START = "<result id=\"".getBytes();
    private static final byte[] RESULT_TAG_OPEN_END = "\">".getBytes();
    private static final byte[] RESULT_TAG_CLOSE = "</result>".getBytes();
    private ServletContext servletContext;

    @Override
    public void setServletContext(ServletContext ctx) {
        this.servletContext = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            response.setContentType("text/xml");
            SAXReader xmlReader = new SAXReader();
            Document doc = xmlReader.read((InputStream)request.getInputStream());
            Element env = doc.getRootElement();
            RequestContext ctx = this.unmarshalContext(env);
            HttpSession session = request.getSession(true);
            Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
            Lifecycle.setServletRequest((ServletRequest)request);
            Lifecycle.beginRequest(this.servletContext, session, (ServletRequest)request);
            Manager.instance().restoreConversation(ctx.getConversationId());
            Lifecycle.resumeConversation(session);
            List<Call> calls = this.unmarshalCalls(env);
            for (Call call : calls) {
                call.execute();
            }
            ctx.setConversationId(Manager.instance().getCurrentConversationId());
            Manager.instance().storeConversation(ContextAdaptor.getSession(session), response);
            Lifecycle.endRequest();
            this.marshalResponse(calls, ctx, (OutputStream)response.getOutputStream());
        }
        catch (Exception ex) {
            log.error((Object)"Error during remote request", (Throwable)ex);
            Lifecycle.endRequest();
        }
        finally {
            Lifecycle.setServletRequest(null);
            Lifecycle.setPhaseId(null);
            log.debug((Object)"ended request");
        }
    }

    private RequestContext unmarshalContext(Element env) {
        Element convId;
        Element context;
        RequestContext ctx = new RequestContext();
        Element header = env.element("header");
        if (header != null && (context = header.element("context")) != null && (convId = context.element("conversationId")) != null) {
            ctx.setConversationId(convId.getText());
        }
        return ctx;
    }

    private List<Call> unmarshalCalls(Element env) throws Exception {
        try {
            ArrayList<Call> calls = new ArrayList<Call>();
            List callElements = env.element("body").elements("call");
            for (Element e : callElements) {
                Call call = new Call(e.attributeValue("id"), e.attributeValue("component"), e.attributeValue("method"));
                Element refsNode = e.element("refs");
                Iterator iter = refsNode.elementIterator("ref");
                while (iter.hasNext()) {
                    call.getContext().createWrapperFromElement((Element)iter.next());
                }
                for (Wrapper w : call.getContext().getInRefs().values()) {
                    w.unmarshal();
                }
                Element paramsNode = e.element("params");
                iter = paramsNode.elementIterator("param");
                while (iter.hasNext()) {
                    Element param = (Element)iter.next();
                    call.addParameter(call.getContext().createWrapperFromElement((Element)param.elementIterator().next()));
                }
                calls.add(call);
            }
            return calls;
        }
        catch (Exception ex) {
            log.error((Object)"Error unmarshalling calls from request", (Throwable)ex);
            throw ex;
        }
    }

    private void marshalResponse(List<Call> calls, RequestContext ctx, OutputStream out) throws IOException {
        out.write(ENVELOPE_TAG_OPEN);
        if (ctx.getConversationId() != null) {
            out.write(HEADER_OPEN);
            out.write(CONTEXT_TAG_OPEN);
            out.write(CONVERSATION_ID_TAG_OPEN);
            out.write(ctx.getConversationId().getBytes());
            out.write(CONVERSATION_ID_TAG_CLOSE);
            out.write(CONTEXT_TAG_CLOSE);
            out.write(HEADER_CLOSE);
        }
        out.write(BODY_TAG_OPEN);
        for (Call call : calls) {
            out.write(RESULT_TAG_OPEN_START);
            out.write(call.getId().getBytes());
            out.write(RESULT_TAG_OPEN_END);
            out.write(VALUE_TAG_OPEN);
            call.getContext().createWrapperFromObject(call.getResult()).marshal(out);
            out.write(VALUE_TAG_CLOSE);
            out.write(REFS_TAG_OPEN);
            for (int i = 0; i < call.getContext().getOutRefs().size(); ++i) {
                Wrapper wrapper = call.getContext().getOutRefs().get(i);
                out.write(REF_TAG_OPEN_START);
                out.write(Integer.toString(i).getBytes());
                out.write(REF_TAG_OPEN_END);
                wrapper.serialize(out);
                out.write(REF_TAG_CLOSE);
            }
            out.write(REFS_TAG_CLOSE);
            out.write(RESULT_TAG_CLOSE);
        }
        out.write(BODY_TAG_CLOSE);
        out.write(ENVELOPE_TAG_CLOSE);
        out.flush();
    }
}

