/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.util.Transactions;

public class SeamExceptionFilter
implements Filter {
    private static final Log log = LogFactory.getLog(SeamExceptionFilter.class);
    private ServletContext context;

    public void init(FilterConfig cfg) throws ServletException {
        this.context = cfg.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
            this.rollbackTransactionIfNecessary();
        }
        catch (Exception e) {
            log.error((Object)"uncaught exception handled by Seam", (Throwable)e);
            this.rollbackTransactionIfNecessary();
            this.endWebRequestAfterException(request);
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWebRequestAfterException(ServletRequest request) {
        Lifecycle.setException(true);
        try {
            Lifecycle.beginInitialization(this.context);
            Lifecycle.endRequest();
        }
        catch (Exception ee) {
            log.error((Object)"could not destroy contexts", (Throwable)ee);
        }
        finally {
            Lifecycle.setException(false);
        }
    }

    private void rollbackTransactionIfNecessary() {
        try {
            if (Transactions.isTransactionActiveOrMarkedRollback()) {
                log.info((Object)"killing transaction");
                Transactions.getUserTransaction().rollback();
            }
        }
        catch (Exception te) {
            log.error((Object)"could not roll back transaction", (Throwable)te);
        }
    }

    public void destroy() {
    }
}

