/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Sorter<T> {
    public void sort(List<T> originalList) {
        ArrayList<T> remaining = new ArrayList<T>(originalList);
        originalList.clear();
        this.sortInto(originalList, remaining);
        if (!this.isGoodOrder(originalList)) {
            throw new IllegalStateException();
        }
    }

    private boolean sortInto(List<T> result, List<T> remaining) {
        if (remaining.size() == 0) {
            return true;
        }
        int loc = result.size();
        result.add(null);
        for (int i = 0; i < remaining.size(); ++i) {
            ArrayList<T> nowRemaining = new ArrayList<T>(remaining);
            Object interceptor = nowRemaining.remove(i);
            result.set(loc, interceptor);
            if (!this.isGoodOrder(result) || !this.sortInto(result, nowRemaining)) continue;
            return true;
        }
        result.remove(loc);
        return false;
    }

    private boolean isGoodOrder(List<T> list) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!this.isOrderViolated(list.get(j), list.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract boolean isOrderViolated(T var1, T var2);
}

