/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import javax.persistence.Entity;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seam {
    private static final String SESSION_INVALID = "org.jboss.seam.sessionInvalid";

    public static ScopeType getComponentScope(Class<?> clazz) {
        return clazz.isAnnotationPresent(Scope.class) ? clazz.getAnnotation(Scope.class).value() : Seam.getComponentType(clazz).getDefaultScope();
    }

    public static ScopeType getComponentRoleScope(Class clazz, Role role) {
        return role.scope() == ScopeType.UNSPECIFIED ? Seam.getComponentType(clazz).getDefaultScope() : role.scope();
    }

    public static ComponentType getComponentType(Class<?> clazz) {
        if (clazz.isAnnotationPresent(EJB.STATEFUL)) {
            return ComponentType.STATEFUL_SESSION_BEAN;
        }
        if (clazz.isAnnotationPresent(EJB.STATELESS)) {
            return ComponentType.STATELESS_SESSION_BEAN;
        }
        if (clazz.isAnnotationPresent(EJB.MESSAGE_DRIVEN)) {
            return ComponentType.MESSAGE_DRIVEN_BEAN;
        }
        if (clazz.isAnnotationPresent(Entity.class)) {
            return ComponentType.ENTITY_BEAN;
        }
        return ComponentType.JAVA_BEAN;
    }

    public static String getComponentName(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            Name name = clazz.getAnnotation(Name.class);
            if (name != null) {
                return name.value();
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Class getEntityClass(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            Entity name = clazz.getAnnotation(Entity.class);
            if (name != null) {
                return clazz;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static boolean isEntityClass(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            if (clazz.isAnnotationPresent(Entity.class)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static String getEjbName(Class<?> clazz) {
        switch (Seam.getComponentType(clazz)) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return null;
            }
            case STATEFUL_SESSION_BEAN: {
                String statefulName = EJB.name(clazz.getAnnotation(EJB.STATEFUL));
                return statefulName.equals("") ? Seam.unqualifyClassName(clazz) : statefulName;
            }
            case STATELESS_SESSION_BEAN: {
                String statelessName = EJB.name(clazz.getAnnotation(EJB.STATELESS));
                return statelessName.equals("") ? Seam.unqualifyClassName(clazz) : statelessName;
            }
            case MESSAGE_DRIVEN_BEAN: {
                String mdName = EJB.name(clazz.getAnnotation(EJB.MESSAGE_DRIVEN));
                return mdName.equals("") ? Seam.unqualifyClassName(clazz) : mdName;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String unqualifyClassName(Class<?> clazz) {
        return Strings.unqualify(Strings.unqualify(clazz.getName()), '$');
    }

    public static InterceptionType getInterceptionType(Class<?> clazz) {
        ComponentType componentType = Seam.getComponentType(clazz);
        if (componentType == ComponentType.ENTITY_BEAN) {
            return InterceptionType.NEVER;
        }
        if (Seam.getComponentType(clazz) == ComponentType.MESSAGE_DRIVEN_BEAN) {
            return InterceptionType.ALWAYS;
        }
        if (clazz.isAnnotationPresent(Intercept.class)) {
            return clazz.getAnnotation(Intercept.class).value();
        }
        return InterceptionType.ALWAYS;
    }

    public static void invalidateSession() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Contexts.getSessionContext().set(SESSION_INVALID, true);
    }

    public static boolean isSessionInvalid() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Boolean isSessionInvalid = (Boolean)Contexts.getSessionContext().get(SESSION_INVALID);
        return isSessionInvalid != null && isSessionInvalid != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component componentForName(String name) {
        if (Contexts.isApplicationContextActive()) {
            return Component.forName(name);
        }
        Lifecycle.beginApplication();
        try {
            Component component = Component.forName(name);
            return component;
        }
        finally {
            Lifecycle.endApplication();
        }
    }
}

