/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.core.PersistenceContexts;
import org.jboss.seam.persistence.PersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassivatedEntity
implements Serializable {
    private Object id;
    private String persistenceContext;
    private String fieldName;
    private Class<?> entityClass;

    private PassivatedEntity(Object id, Class<?> entityClass, String persistenceContext, String fieldName) {
        this.id = id;
        this.persistenceContext = persistenceContext;
        this.fieldName = fieldName;
        this.entityClass = entityClass;
    }

    public String getPersistenceContext() {
        return this.persistenceContext;
    }

    public Object getId() {
        return this.id;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Object toEntityReference() {
        Object persistenceContext = Component.getInstance(this.getPersistenceContext());
        if (persistenceContext == null) {
            return null;
        }
        if (persistenceContext instanceof EntityManager) {
            EntityManager em = (EntityManager)persistenceContext;
            return em.isOpen() ? em.getReference(this.getEntityClass(), this.getId()) : null;
        }
        Session session = (Session)persistenceContext;
        return session.isOpen() ? session.load(this.getEntityClass(), (Serializable)this.getId()) : null;
    }

    public static PassivatedEntity createPassivatedEntity(Object value, String fieldName) {
        Class entityClass = Seam.getEntityClass(value.getClass());
        if (entityClass != null) {
            for (String persistenceContextName : PersistenceContexts.instance().getTouchedContexts()) {
                Serializable id;
                boolean managed;
                Object persistenceContext = Component.getInstance(persistenceContextName);
                if (persistenceContext instanceof EntityManager) {
                    EntityManager em = (EntityManager)persistenceContext;
                    try {
                        managed = em.isOpen() && em.contains(value);
                    }
                    catch (RuntimeException re) {
                        managed = false;
                    }
                    id = managed ? PersistenceProvider.instance().getId(value, em) : null;
                } else {
                    Session session = (Session)persistenceContext;
                    try {
                        managed = session.isOpen() && session.contains(value);
                    }
                    catch (RuntimeException re) {
                        managed = false;
                    }
                    Serializable serializable = id = managed ? session.getIdentifier(value) : null;
                }
                if (!managed) continue;
                if (id == null) {
                    throw new IllegalStateException("could not get id of: " + fieldName);
                }
                return new PassivatedEntity(id, entityClass, persistenceContextName, fieldName);
            }
        }
        return null;
    }
}

