/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import javax.faces.application.FacesMessage;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.core.Actor;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.ManagedJbpmContext;
import org.jboss.seam.core.ProcessInstance;
import org.jboss.seam.core.TaskInstance;
import org.jboss.seam.core.Transition;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.core.businessProcess")
@Intercept(value=InterceptionType.NEVER)
@Install(dependencies={"org.jboss.seam.core.jbpm"}, precedence=0)
public class BusinessProcess
extends AbstractMutable
implements Serializable {
    private Long processId;
    private Long taskId;

    public static BusinessProcess instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (BusinessProcess)Component.getInstance(BusinessProcess.class, ScopeType.CONVERSATION);
    }

    public boolean hasCurrentProcess() {
        return this.processId != null;
    }

    public boolean hasCurrentTask() {
        return this.taskId != null;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.setDirty(this.processId, processId);
        this.processId = processId;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.setDirty(this.taskId, taskId);
        this.taskId = taskId;
    }

    public void createProcess(String processDefinitionName) {
        JbpmContext jbpmContext = ManagedJbpmContext.instance();
        ProcessDefinition pd = jbpmContext.getGraphSession().findLatestProcessDefinition(processDefinitionName);
        if (pd == null) {
            throw new IllegalArgumentException("Unknown process definition: " + processDefinitionName);
        }
        org.jbpm.graph.exe.ProcessInstance process = pd.createProcessInstance();
        jbpmContext.save(process);
        this.setProcessId(process.getId());
        Contexts.getBusinessProcessContext().flush();
        process.signal();
        Events.instance().raiseEvent("org.jboss.seam.createProcess." + processDefinitionName, new Object[0]);
    }

    public void startTask() {
        String actorId = Actor.instance().getId();
        org.jbpm.taskmgmt.exe.TaskInstance task = TaskInstance.instance();
        if (actorId != null) {
            task.start(actorId);
        } else {
            task.start();
        }
        Events.instance().raiseEvent("org.jboss.seam.startTask." + task.getTask().getName(), new Object[0]);
    }

    public void endTask(String transitionName) {
        org.jbpm.taskmgmt.exe.TaskInstance task = TaskInstance.instance();
        if (task == null) {
            throw new IllegalStateException("no task instance associated with context");
        }
        if (transitionName == null || "".equals(transitionName)) {
            transitionName = Transition.instance().getName();
        }
        if (transitionName == null) {
            task.end();
        } else {
            task.end(transitionName);
        }
        this.setTaskId(null);
        Events.instance().raiseEvent("org.jboss.seam.endTask." + task.getTask().getName(), new Object[0]);
        org.jbpm.graph.exe.ProcessInstance process = ProcessInstance.instance();
        if (process.hasEnded()) {
            Events.instance().raiseEvent("org.jboss.seam.endProcess." + process.getProcessDefinition().getName(), new Object[0]);
        }
    }

    public void transition(String transitionName) {
        org.jbpm.graph.exe.ProcessInstance process = ProcessInstance.instance();
        process.signal(transitionName);
        if (process.hasEnded()) {
            Events.instance().raiseEvent("org.jboss.seam.endProcess." + process.getProcessDefinition().getName(), new Object[0]);
        }
    }

    public boolean resumeTask(Long taskId) {
        this.setTaskId(taskId);
        org.jbpm.taskmgmt.exe.TaskInstance task = TaskInstance.instance();
        if (task == null) {
            this.taskNotFound(taskId);
            return false;
        }
        if (task.hasEnded()) {
            this.taskEnded(taskId);
            return false;
        }
        this.setProcessId(task.getTaskMgmtInstance().getProcessInstance().getId());
        Events.instance().raiseEvent("org.jboss.seam.initTask." + task.getTask().getName(), new Object[0]);
        return true;
    }

    public boolean resumeProcess(Long processId) {
        this.setProcessId(processId);
        org.jbpm.graph.exe.ProcessInstance process = ProcessInstance.instance();
        if (process == null) {
            this.processNotFound(processId);
            return false;
        }
        if (process.hasEnded()) {
            this.processEnded(processId);
            return false;
        }
        Events.instance().raiseEvent("org.jboss.seam.initProcess." + process.getProcessDefinition().getName(), new Object[0]);
        return true;
    }

    public boolean validateTask() {
        if (!this.hasCurrentTask()) {
            this.taskNotFound(this.taskId);
            return false;
        }
        if (TaskInstance.instance().hasEnded()) {
            this.taskEnded(this.taskId);
            return false;
        }
        return true;
    }

    protected void taskNotFound(Long taskId) {
        FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.TaskNotFound", "Task #0 not found", taskId);
    }

    protected void taskEnded(Long taskId) {
        FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.TaskEnded", "Task #0 already ended", taskId);
    }

    protected void processEnded(Long processId) {
        FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.ProcessEnded", "Process #0 already ended", processId);
    }

    protected void processNotFound(Long processId) {
        FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.ProcessNotFound", "Process #0 not found", processId);
    }

    public String toString() {
        return "BusinessProcess(processId=" + this.processId + ",taskId=" + this.taskId + ")";
    }
}

