/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Dispatcher;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.util.DTDEntityResolver;
import org.jboss.seam.util.Resources;
import org.xml.sax.EntityResolver;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.events")
@Install(precedence=0)
public class Events {
    private static final Log log = LogFactory.getLog(Events.class);
    private final Map<String, List<Expressions.MethodBinding>> listeners = new HashMap<String, List<Expressions.MethodBinding>>();

    @Create
    public void initialize() throws DocumentException {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/events.xml");
        if (stream == null) {
            log.info((Object)"no events.xml file found");
        } else {
            log.info((Object)"reading events.xml");
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new DTDEntityResolver());
            saxReader.setMergeAdjacentText(true);
            Document doc = saxReader.read(stream);
            List elements = doc.getRootElement().elements("event");
            for (Element event : elements) {
                String type = event.attributeValue("type");
                if (type == null) {
                    throw new IllegalArgumentException("must specify type for <event/> declaration");
                }
                ArrayList<Expressions.MethodBinding> methodBindings = new ArrayList<Expressions.MethodBinding>();
                this.listeners.put(type, methodBindings);
                List actions = event.elements("action");
                for (Element action : actions) {
                    String actionExpression = action.attributeValue("expression");
                    if (actionExpression == null) {
                        throw new IllegalArgumentException("must specify expression for <action/> declaration");
                    }
                    Expressions.MethodBinding methodBinding = Expressions.instance().createMethodBinding(actionExpression);
                    methodBindings.add(methodBinding);
                }
            }
        }
    }

    public void addListener(String type, String methodBindingExpression) {
        Expressions.MethodBinding methodBinding = Expressions.instance().createMethodBinding(methodBindingExpression);
        List<Expressions.MethodBinding> list = this.listeners.get(type);
        if (list == null) {
            list = new ArrayList<Expressions.MethodBinding>();
            this.listeners.put(type, list);
        }
        list.add(methodBinding);
    }

    public void raiseEvent(String type, Object ... parameters) {
        List<Init.ObserverMethod> observers;
        log.debug((Object)("Processing event:" + type));
        List<Expressions.MethodBinding> list = this.listeners.get(type);
        if (list != null) {
            for (Expressions.MethodBinding listener : list) {
                listener.invoke(parameters);
            }
        }
        if ((observers = Init.instance().getObservers(type)) != null) {
            for (Init.ObserverMethod observer : observers) {
                Object listener = Component.getInstance(observer.component.getName(), true);
                observer.component.callComponentMethod(listener, observer.method, parameters);
            }
        }
    }

    public void raiseAsynchronousEvent(String type, Object ... parameters) {
        Dispatcher.instance().scheduleEvent(type, 0L, null, null, parameters);
    }

    public void raiseTimedEvent(String type, long duration, Object ... parameters) {
        Dispatcher.instance().scheduleEvent(type, duration, null, null, parameters);
    }

    public void raiseTimedEvent(String type, Date expiration, Object ... parameters) {
        Dispatcher.instance().scheduleEvent(type, null, expiration, null, parameters);
    }

    public void raiseTimedEvent(String type, Date expiration, long intervalDuration, Object ... parameters) {
        Dispatcher.instance().scheduleEvent(type, null, expiration, intervalDuration, parameters);
    }

    public void raiseTimedEvent(String type, long duration, long intervalDuration) {
        Dispatcher.instance().scheduleEvent(type, duration, null, intervalDuration, new Object[0]);
    }

    public static boolean exists() {
        return Contexts.isApplicationContextActive() && Contexts.getApplicationContext().isSet(Seam.getComponentName(Events.class));
    }

    public static Events instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Events)Component.getInstance(Events.class, ScopeType.APPLICATION);
    }
}

